/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.NotFoundException;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reportdata.storage.StorageReportList;
import org.duracloud.reportdata.storage.serialize.StorageReportSerializer;
import org.duracloud.reporter.error.ReportBuilderException;
import org.duracloud.reporter.storage.StorageReportConverter;
import org.duracloud.reporter.storage.metrics.DuraStoreMetricsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageReportHandler {
    private final Logger log = LoggerFactory.getLogger(StorageReportHandler.class);
    private static final String REPORT_FILE_NAME_SUFFIX = ".xml";
    public static final String COMPLETION_TIME_META = "completion-time";
    public static final String ELAPSED_TIME_META = "elapsed-time";
    public static final int maxRetries = 8;
    protected String storageSpace;
    private ContentStore primaryStore = null;
    private String reportFileNamePrefix;
    private String reportErrorLogFileName;

    public StorageReportHandler(ContentStoreManager storeMgr, String storageSpace, String reportFileNamePrefix, String reportErrorLogFileName) {
        this.storageSpace = storageSpace;
        this.reportFileNamePrefix = reportFileNamePrefix;
        this.reportErrorLogFileName = reportErrorLogFileName;
        try {
            this.primaryStore = storeMgr.getPrimaryContentStore();
            try {
                this.primaryStore.getSpaceProperties(storageSpace);
            }
            catch (NotFoundException e) {
                this.primaryStore.createSpace(storageSpace);
            }
        }
        catch (ContentStoreException e) {
            throw new DuraCloudRuntimeException("Error checking metrics storage space: " + e.getMessage());
        }
    }

    public InputStream getStorageReportStream(String reportId) throws ContentStoreException {
        try {
            return this.primaryStore.getContent(this.storageSpace, reportId).getStream();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public StorageReport getStorageReport(String reportId) throws ContentStoreException {
        try {
            Content content = this.primaryStore.getContent(this.storageSpace, reportId);
            return this.deserializeStorageReport(content);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private StorageReport deserializeStorageReport(Content content) {
        StorageReportSerializer serializer = new StorageReportSerializer();
        return (StorageReport)serializer.deserialize(content.getStream());
    }

    public InputStream getLatestStorageReportStream() throws ContentStoreException {
        Content latestContent = this.getLatestStorageReportContent();
        if (null != latestContent) {
            return latestContent.getStream();
        }
        return null;
    }

    public StorageReport getLatestStorageReport() throws ContentStoreException {
        Content latestContent = this.getLatestStorageReportContent();
        if (null != latestContent) {
            return this.deserializeStorageReport(latestContent);
        }
        return null;
    }

    private Content getLatestStorageReportContent() throws ContentStoreException {
        LinkedList<String> reportList = this.getSortedReportList();
        if (reportList.size() > 0) {
            String latestContentId = reportList.getFirst();
            Content latestContent = this.primaryStore.getContent(this.storageSpace, latestContentId);
            return latestContent;
        }
        return null;
    }

    private LinkedList<String> getSortedReportList() throws ContentStoreException {
        Iterator reports = this.primaryStore.getSpaceContents(this.storageSpace, this.reportFileNamePrefix);
        LinkedList<String> reportList = new LinkedList<String>();
        while (reports.hasNext() && reportList.size() < 5000) {
            reportList.add((String)reports.next());
        }
        if (reportList.size() > 0) {
            Collections.sort(reportList);
            Collections.reverse(reportList);
        }
        return reportList;
    }

    public StorageReportList getStorageReportList() throws ContentStoreException {
        return new StorageReportList(this.getSortedReportList());
    }

    public String storeReport(DuraStoreMetricsCollector metrics, long completionTime, long elapsedTime) {
        String contentId = this.buildContentId(completionTime);
        StorageReportConverter converter = new StorageReportConverter();
        StorageReport report = converter.createStorageReport(contentId, metrics, completionTime, elapsedTime);
        StorageReportSerializer serializer = new StorageReportSerializer();
        String xml = serializer.serialize((Object)report);
        byte[] metricsBytes = this.getXmlBytes(xml);
        this.log.info("Storing Storage Report with ID: " + contentId);
        for (int i = 0; i < 8; ++i) {
            try {
                this.primaryStore.addContent(this.storageSpace, contentId, (InputStream)new ByteArrayInputStream(metricsBytes), (long)metricsBytes.length, "application/xml", this.getMetricsChecksum(xml), null);
                return contentId;
            }
            catch (ContentStoreException e) {
                this.log.warn("Exception attempting to store storage report: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new ReportBuilderException("Exceeded retries attempting to store storage report");
    }

    private String buildContentId(long time) {
        String date = DateUtil.convertToString((long)time);
        return this.reportFileNamePrefix + date + REPORT_FILE_NAME_SUFFIX;
    }

    private byte[] getXmlBytes(String xml) {
        try {
            return xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getMetricsChecksum(String xml) {
        ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        return util.generateChecksum(xml);
    }

    public void addToErrorLog(String errMsg) {
        InputStream existingLog = null;
        long existingLogSize = 0L;
        try {
            Content errorLogContent = this.primaryStore.getContent(this.storageSpace, this.reportErrorLogFileName);
            if (null != errorLogContent) {
                existingLog = errorLogContent.getStream();
                existingLogSize = this.getExistingLogSize(errorLogContent);
            }
        }
        catch (ContentStoreException e) {
            // empty catch block
        }
        String logMsg = this.createLogMsg(errMsg);
        InputStream newMsg = this.createLogMsgStream(logMsg);
        InputStream newLog = null != existingLog ? new SequenceInputStream(newMsg, existingLog) : newMsg;
        for (int i = 0; i < 8; ++i) {
            try {
                this.primaryStore.addContent(this.storageSpace, this.reportErrorLogFileName, newLog, existingLogSize + (long)logMsg.length(), "text/plain", null, null);
                return;
            }
            catch (ContentStoreException e) {
                this.log.warn("Exception attempting to store error log: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        this.log.error("Unable to store error log file!");
    }

    private String createLogMsg(String msg) {
        return DateUtil.now() + "  " + msg + "\n";
    }

    private InputStream createLogMsgStream(String logMsg) {
        try {
            return IOUtils.toInputStream((String)logMsg, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private long getExistingLogSize(Content logContent) {
        String logSize;
        Map properties = logContent.getProperties();
        if (null != properties && null != (logSize = (String)properties.get("content-size"))) {
            try {
                return Long.valueOf(logSize);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return 0L;
    }

    private void wait(int index) {
        try {
            Thread.sleep(1000 * index);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

