/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage.metrics;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.reporter.storage.metrics.MetricsCollector;
import org.duracloud.reporter.storage.metrics.SpaceMetricsCollector;

public class StorageProviderMetricsCollector
extends MetricsCollector {
    private String storageProviderId;
    private String storageProviderType;
    private Map<String, SpaceMetricsCollector> spaceMetrics;

    public StorageProviderMetricsCollector(String storageProviderId, String storageProviderType) {
        this.storageProviderId = storageProviderId;
        this.storageProviderType = storageProviderType;
        this.spaceMetrics = new HashMap<String, SpaceMetricsCollector>();
    }

    @Override
    public void update(String mimetype, long size) {
        String error = "Use update(String, String, long)";
        throw new UnsupportedOperationException(error);
    }

    public void update(String spaceId, String mimetype, long size) {
        super.update(mimetype, size);
        SpaceMetricsCollector spaceMet = this.spaceMetrics.get(spaceId);
        if (null == spaceMet) {
            spaceMet = new SpaceMetricsCollector(spaceId);
            this.spaceMetrics.put(spaceId, spaceMet);
        }
        spaceMet.update(mimetype, size);
    }

    public String getStorageProviderId() {
        return this.storageProviderId;
    }

    public String getStorageProviderType() {
        return this.storageProviderType;
    }

    public Map<String, SpaceMetricsCollector> getSpaceMetrics() {
        return this.spaceMetrics;
    }
}

