/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duracloud.reportdata.storage.StorageReport;
import org.duracloud.reportdata.storage.metrics.MimetypeMetrics;
import org.duracloud.reportdata.storage.metrics.SpaceMetrics;
import org.duracloud.reportdata.storage.metrics.StorageMetrics;
import org.duracloud.reportdata.storage.metrics.StorageProviderMetrics;
import org.duracloud.reporter.storage.metrics.DuraStoreMetricsCollector;
import org.duracloud.reporter.storage.metrics.MimetypeMetricsCollector;
import org.duracloud.reporter.storage.metrics.SpaceMetricsCollector;
import org.duracloud.reporter.storage.metrics.StorageProviderMetricsCollector;

public class StorageReportConverter {
    public StorageReport createStorageReport(String contentId, DuraStoreMetricsCollector metrics, long completionTime, long elapsedTime) {
        LinkedList<StorageProviderMetrics> spMetrics = new LinkedList<StorageProviderMetrics>();
        for (StorageProviderMetricsCollector provider : metrics.getStorageProviderMetrics().values()) {
            LinkedList<SpaceMetrics> spaceMetrics = new LinkedList<SpaceMetrics>();
            for (SpaceMetricsCollector space : provider.getSpaceMetrics().values()) {
                spaceMetrics.add(new SpaceMetrics(space.getSpaceName(), space.getTotalItems(), space.getTotalSize(), this.convertMime(space.getMimetypeMetrics())));
            }
            spMetrics.add(new StorageProviderMetrics(provider.getStorageProviderId(), provider.getStorageProviderType(), spaceMetrics, provider.getTotalItems(), provider.getTotalSize(), this.convertMime(provider.getMimetypeMetrics())));
        }
        StorageMetrics storageMetrics = new StorageMetrics(spMetrics, metrics.getTotalItems(), metrics.getTotalSize(), this.convertMime(metrics.getMimetypeMetrics()));
        return new StorageReport(contentId, storageMetrics, completionTime, elapsedTime);
    }

    private List<MimetypeMetrics> convertMime(Map<String, MimetypeMetricsCollector> mimeMetrics) {
        LinkedList<MimetypeMetrics> converted = new LinkedList<MimetypeMetrics>();
        for (MimetypeMetricsCollector mime : mimeMetrics.values()) {
            converted.add(new MimetypeMetrics(mime.getMimetype(), mime.getTotalItems(), mime.getTotalSize()));
        }
        return converted;
    }
}

