/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.reporter.storage.metrics;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.reporter.storage.metrics.MimetypeMetricsCollector;

public abstract class MetricsCollector {
    private long totalItems = 0L;
    private long totalSize = 0L;
    private Map<String, MimetypeMetricsCollector> mimetypeMetrics = new HashMap<String, MimetypeMetricsCollector>();

    public void update(String mimetype, long size) {
        ++this.totalItems;
        this.totalSize += size;
        MimetypeMetricsCollector mimeMet = this.mimetypeMetrics.get(mimetype);
        if (null == mimeMet) {
            mimeMet = new MimetypeMetricsCollector(mimetype);
            this.mimetypeMetrics.put(mimetype, mimeMet);
        }
        mimeMet.update(size);
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public Map<String, MimetypeMetricsCollector> getMimetypeMetrics() {
        return this.mimetypeMetrics;
    }
}

