/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    public ResourcePropertySource(String name, EncodedResource resource) throws IOException {
        super(name, PropertiesLoaderUtils.loadProperties(resource));
    }

    public ResourcePropertySource(EncodedResource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource.getResource()), resource);
    }

    public ResourcePropertySource(String name, Resource resource) throws IOException {
        super(name, PropertiesLoaderUtils.loadProperties(new EncodedResource(resource)));
    }

    public ResourcePropertySource(Resource resource) throws IOException {
        this(ResourcePropertySource.getNameForResource(resource), resource);
    }

    public ResourcePropertySource(String name, String location, ClassLoader classLoader) throws IOException {
        this(name, new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String location, ClassLoader classLoader) throws IOException {
        this(new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String name, String location) throws IOException {
        this(name, new DefaultResourceLoader().getResource(location));
    }

    public ResourcePropertySource(String location) throws IOException {
        this(new DefaultResourceLoader().getResource(location));
    }

    private ResourcePropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    public ResourcePropertySource withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        return new ResourcePropertySource(name, (Map)this.source);
    }

    private static String getNameForResource(Resource resource) {
        String name = resource.getDescription();
        if (!StringUtils.hasText(name)) {
            name = resource.getClass().getSimpleName() + "@" + System.identityHashCode(resource);
        }
        return name;
    }
}

