/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.autoscaling.model.LoadBalancerState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeLoadBalancersResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<LoadBalancerState> loadBalancers;
    private String nextToken;

    public List<LoadBalancerState> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ListWithAutoConstructFlag();
            this.loadBalancers.setAutoConstruct(true);
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancerState> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
        loadBalancersCopy.addAll(loadBalancers);
        this.loadBalancers = loadBalancersCopy;
    }

    public DescribeLoadBalancersResult withLoadBalancers(LoadBalancerState ... loadBalancers) {
        if (this.getLoadBalancers() == null) {
            this.setLoadBalancers(new ArrayList<LoadBalancerState>(loadBalancers.length));
        }
        for (LoadBalancerState value : loadBalancers) {
            this.getLoadBalancers().add(value);
        }
        return this;
    }

    public DescribeLoadBalancersResult withLoadBalancers(Collection<LoadBalancerState> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
        } else {
            ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
            loadBalancersCopy.addAll(loadBalancers);
            this.loadBalancers = loadBalancersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeLoadBalancersResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: " + this.getLoadBalancers() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResult)) {
            return false;
        }
        DescribeLoadBalancersResult other = (DescribeLoadBalancersResult)obj;
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeLoadBalancersResult clone() {
        try {
            return (DescribeLoadBalancersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

