/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.S3DataSpec;
import com.amazonaws.util.json.JSONWriter;

public class S3DataSpecJsonMarshaller {
    private static S3DataSpecJsonMarshaller instance;

    public void marshall(S3DataSpec s3DataSpec, JSONWriter jsonWriter) {
        if (s3DataSpec == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (s3DataSpec.getDataLocationS3() != null) {
                jsonWriter.key("DataLocationS3").value(s3DataSpec.getDataLocationS3());
            }
            if (s3DataSpec.getDataRearrangement() != null) {
                jsonWriter.key("DataRearrangement").value(s3DataSpec.getDataRearrangement());
            }
            if (s3DataSpec.getDataSchema() != null) {
                jsonWriter.key("DataSchema").value(s3DataSpec.getDataSchema());
            }
            if (s3DataSpec.getDataSchemaLocationS3() != null) {
                jsonWriter.key("DataSchemaLocationS3").value(s3DataSpec.getDataSchemaLocationS3());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DataSpecJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DataSpecJsonMarshaller();
        }
        return instance;
    }
}

