/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.config;

import java.io.File;
import java.io.Serializable;
import java.util.List;

public class RetrievalToolConfig
implements Serializable {
    private String host;
    private int port;
    private String context;
    private String username;
    private String password;
    private String storeId;
    private List<String> spaces;
    private boolean allSpaces;
    private File contentDir;
    private File workDir;
    private boolean overwrite;
    private int numThreads;
    private String version;
    private boolean applyTimestamps;
    private boolean listOnly;
    private File listFile;

    public String getPrintableConfig() {
        StringBuilder config = new StringBuilder();
        config.append("\n--------------------------------------\n");
        config.append(" Retrieval Tool " + this.version + " - Configuration");
        config.append("\n--------------------------------------\n");
        if (this.allSpaces) {
            config.append("Retrieve all spaces: true");
        } else {
            config.append("Retrieve spaces:");
            for (String space : this.spaces) {
                config.append(" ").append(space);
            }
        }
        config.append("\n");
        config.append("DuraStore Host: ");
        config.append(this.getHost()).append("\n");
        config.append("DuraStore Port: ");
        config.append(this.getPort()).append("\n");
        config.append("DuraStore Username: ");
        config.append(this.getUsername()).append("\n");
        if (this.storeId != null) {
            config.append("DuraStore Store: ");
            config.append(this.getStoreId()).append("\n");
        }
        config.append("Retrieval Tool Content Directory: ");
        config.append(this.getContentDir().getAbsolutePath()).append("\n");
        config.append("Retrieval Tool Work Directory: ");
        config.append(this.getWorkDir().getAbsolutePath()).append("\n");
        config.append("Retrieval Tool Overwrite Local Files: ");
        config.append(this.isOverwrite()).append("\n");
        config.append("Retrieval Tool Retain File Time Stamps: ");
        config.append(this.isApplyTimestamps()).append("\n");
        config.append("Retrieval Tool List Content Only: ");
        config.append(this.isListOnly()).append("\n");
        if (this.listFile != null) {
            config.append("Retrieval Tool content ID 'list file': ");
            config.append(this.listFile.getAbsolutePath()).append("\n");
        }
        config.append("--------------------------------------\n");
        return config.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public List<String> getSpaces() {
        return this.spaces;
    }

    public void setSpaces(List<String> spaces) {
        this.spaces = spaces;
    }

    public boolean isAllSpaces() {
        return this.allSpaces;
    }

    public void setAllSpaces(boolean allSpaces) {
        this.allSpaces = allSpaces;
    }

    public File getContentDir() {
        return this.contentDir;
    }

    public void setContentDir(File contentDir) {
        this.contentDir = contentDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isApplyTimestamps() {
        return this.applyTimestamps;
    }

    public void setApplyTimestamps(boolean applyTimestamps) {
        this.applyTimestamps = applyTimestamps;
    }

    public boolean isListOnly() {
        return this.listOnly;
    }

    public void setListOnly(boolean listOnly) {
        this.listOnly = listOnly;
    }

    public File getListFile() {
        return this.listFile;
    }

    public void setListFile(File listFile) {
        this.listFile = listFile;
    }
}

