/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import java.io.File;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.duracloud.client.ContentStore;
import org.duracloud.retrieval.mgmt.SpaceListWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceListManager
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(SpaceListManager.class);
    private ThreadPoolExecutor workerPool;
    private ContentStore contentStore;
    private File contentDir;
    private List<String> spaces;
    private boolean overwrite = true;
    private boolean complete = false;

    public SpaceListManager(ContentStore contentStore, File contentDir, List<String> spaces, boolean overwrite, int threads) {
        this.contentStore = contentStore;
        this.contentDir = contentDir;
        this.spaces = spaces;
        this.overwrite = overwrite;
        this.workerPool = new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public void run() {
        while (!this.complete) {
            for (String spaceName : this.spaces) {
                while (!this.retrieveSpaceList(spaceName)) {
                    this.sleep(1000L);
                }
            }
            this.shutdown();
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean retrieveSpaceList(String spaceName) {
        try {
            SpaceListWorker worker = new SpaceListWorker(this.contentStore, spaceName, this.contentDir, this.overwrite);
            this.workerPool.execute(worker);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    public void shutdown() {
        this.logger.info("Closing SpaceList Manager");
        this.workerPool.shutdown();
        try {
            this.workerPool.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

