/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.source;

import java.util.List;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.util.ChunkUtil;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.retrieval.mgmt.RetrievalListener;
import org.duracloud.retrieval.source.DuraStoreRetrievalSource;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.FileStitcherListener;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.datasource.impl.DuraStoreDataSource;
import org.duracloud.stitch.error.InvalidManifestException;
import org.duracloud.stitch.impl.FileStitcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreStitchingRetrievalSource
extends DuraStoreRetrievalSource {
    private final Logger log = LoggerFactory.getLogger(DuraStoreStitchingRetrievalSource.class);
    private FileStitcher stitcher;
    private ChunkUtil chunkUtil;

    public DuraStoreStitchingRetrievalSource(ContentStore store, List<String> spaces, boolean allSpaces) {
        super(store, spaces, allSpaces);
        this.stitcher = new FileStitcherImpl((DataSource)new DuraStoreDataSource(store));
        this.chunkUtil = new ChunkUtil();
    }

    @Override
    public ContentItem getNextContentItem() {
        this.log.debug("enter getNextContentItem()");
        ContentItem item = super.getNextContentItem();
        if (null != item && this.chunkUtil.isChunk(item.getContentId())) {
            this.log.debug("skipping chunk item: {}", (Object)item);
            item = this.getNextContentItem();
        }
        this.log.debug("returning item: {}", (Object)item);
        return item;
    }

    @Override
    public String getSourceChecksum(ContentItem contentItem) {
        if (this.chunkUtil.isChunkManifest(contentItem.getContentId())) {
            try {
                ChunksManifest manifest = this.stitcher.getManifest(contentItem.getSpaceId(), contentItem.getContentId());
                return manifest.getHeader().getSourceMD5();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get checksum for " + contentItem.toString() + " due to: " + e.getMessage());
            }
        }
        return super.getSourceChecksum(contentItem);
    }

    @Override
    protected Content doGetContent(ContentItem item, RetrievalListener listener) {
        this.log.debug("enter doGetContent: {}", (Object)item);
        if (null != item && this.chunkUtil.isChunk(item.getContentId())) {
            StringBuilder msg = new StringBuilder();
            msg.append("Unexpected content item: ");
            msg.append(item);
            msg.append(", chunks not allowed for direct access.");
            this.log.error(msg.toString());
            throw new DuraCloudRuntimeException(msg.toString());
        }
        if (null != item && this.chunkUtil.isChunkManifest(item.getContentId())) {
            this.log.debug("retrieving manifest: {}", (Object)item);
            return this.doGetContentFromManifest(item, listener);
        }
        this.log.debug("retrieving basic content: {}", (Object)item);
        return super.doGetContent(item, listener);
    }

    protected Content doGetContentFromManifest(ContentItem item, final RetrievalListener listener) {
        try {
            return this.stitcher.getContentFromManifest(item.getSpaceId(), item.getContentId(), new FileStitcherListener(){

                public void chunkStitched(String chunkId) {
                    if (listener != null) {
                        listener.chunkRetrieved(chunkId);
                    }
                }
            });
        }
        catch (InvalidManifestException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Unable to get content for ");
            msg.append(item);
            msg.append(" due to: ");
            msg.append(e.getMessage());
            this.log.error(msg.toString());
            throw new RuntimeException(msg.toString());
        }
    }
}

