/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.source;

import java.util.Iterator;
import java.util.List;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.retrieval.mgmt.RetrievalListener;
import org.duracloud.retrieval.source.DuraStoreStitchingRetrievalSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreSpecifiedRetrievalSource
extends DuraStoreStitchingRetrievalSource {
    private final Logger log = LoggerFactory.getLogger(DuraStoreSpecifiedRetrievalSource.class);
    private Iterator<String> specifiedContentIds;

    public DuraStoreSpecifiedRetrievalSource(ContentStore store, List<String> singleSpaceList, Iterator<String> specifiedContentIds) {
        super(store, singleSpaceList, false);
        if (singleSpaceList == null) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must not be NULL.");
        }
        if (singleSpaceList.isEmpty()) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must contain 1 space ID.");
        }
        if (singleSpaceList.size() > 1) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must contain only 1 space ID.");
        }
        this.specifiedContentIds = specifiedContentIds;
    }

    @Override
    protected void getNextSpace() {
        if (this.spaceIds.hasNext()) {
            this.currentSpaceId = (String)this.spaceIds.next();
            this.currentContentList = this.specifiedContentIds;
        }
    }

    @Override
    protected Content doGetContent(ContentItem item, RetrievalListener listener) {
        try {
            return this.contentStore.getContent(item.getSpaceId(), item.getContentId());
        }
        catch (ContentStoreException e) {
            this.log.info("Error retrieving content ID: " + item.getContentId() + ".  Trying to get this content again by checking for " + "a chunk manifest for this content ID.");
            ContentItem manifestItem = new ContentItem(item.getSpaceId(), item.getContentId() + ".dura-manifest");
            return this.doGetContentFromManifest(manifestItem, listener);
        }
    }
}

