/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.config;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.duracloud.common.util.CommandLineToolUtil;
import org.duracloud.common.util.ConsolePrompt;
import org.duracloud.retrieval.config.RetrievalConfig;
import org.duracloud.retrieval.config.RetrievalToolConfig;

public class RetrievalToolConfigParser {
    protected static final int DEFAULT_PORT = 443;
    protected static final int DEFAULT_NUM_THREADS = 3;
    protected static final String DEFAULT_CONTEXT = "durastore";
    private Options cmdOptions;
    private CommandLineToolUtil cmdLineUtil = new CommandLineToolUtil();

    public RetrievalToolConfigParser() {
        this.cmdOptions = new Options();
        Option hostOption = new Option("h", "host", true, "the host address of the DuraCloud DuraStore application");
        hostOption.setRequired(true);
        this.cmdOptions.addOption(hostOption);
        Option portOption = new Option("r", "port", true, "the port of the DuraCloud DuraStore application (optional, default value is 443)");
        portOption.setRequired(false);
        this.cmdOptions.addOption(portOption);
        Option usernameOption = new Option("u", "username", true, "the username necessary to perform writes to DuraStore");
        usernameOption.setRequired(true);
        this.cmdOptions.addOption(usernameOption);
        Option passwordOption = new Option("p", "password", true, "the password necessary to perform writes to DuraStore; NOTICE: if no password is specified in the command line the retrieval tool will look for an environment variable named DURACLOUD_PASSWORD containing the password.  Finally, if this environment variable does not exist the user will be prompted for the password.");
        passwordOption.setRequired(false);
        this.cmdOptions.addOption(passwordOption);
        Option storeIdOption = new Option("i", "store-id", true, "the Store ID for the DuraCloud storage provider");
        storeIdOption.setRequired(false);
        this.cmdOptions.addOption(storeIdOption);
        Option spaces = new Option("s", "spaces", true, "the space or spaces from which content will be retrieved");
        spaces.setRequired(false);
        spaces.setArgs(-2);
        this.cmdOptions.addOption(spaces);
        Option allSpaces = new Option("a", "all-spaces", false, "indicates that all spaces should be retrieved; if this option is included the -s option is ignored (optional, not set by default)");
        allSpaces.setRequired(false);
        this.cmdOptions.addOption(allSpaces);
        Option contentDirOption = new Option("c", "content-dir", true, "retrieved content is stored in this local directory");
        contentDirOption.setRequired(true);
        this.cmdOptions.addOption(contentDirOption);
        Option workDirOption = new Option("w", "work-dir", true, "logs and output files will be stored in the work directory (optional, set to duracloud-retrieval-work directory in user's home directory by default)");
        workDirOption.setRequired(false);
        this.cmdOptions.addOption(workDirOption);
        Option overwrite = new Option("o", "overwrite", false, "indicates that existing local files which differ from files in DuraCloud under the same path and name sould be overwritten rather than copied (optional, not set by default)");
        overwrite.setRequired(false);
        this.cmdOptions.addOption(overwrite);
        Option numThreads = new Option("t", "threads", true, "the number of threads in the pool used to manage file transfers (optional, default value is 3)");
        numThreads.setRequired(false);
        this.cmdOptions.addOption(numThreads);
        Option disableTimestamps = new Option("d", "disable-timestamps", false, "indicates that timestamp information found as content item properties in DuraCloud should not be applied to local files as they are retrieved (optional, not set by default)");
        disableTimestamps.setRequired(false);
        this.cmdOptions.addOption(disableTimestamps);
        Option listOnly = new Option("l", "list-only", false, "indicates that the retrieval tool should create a file listing the contents of the specified space rather than downloading the actual content files.  The list file will be placed in the specified content directory. One list file will be created for each specified space.(optional, not set by default)");
        listOnly.setRequired(false);
        this.cmdOptions.addOption(listOnly);
        Option listFile = new Option("f", "list-file", true, "retrieve specific contents using content IDs in the specified file.  The specified file should contain one content ID per line.  This option can only operate on one space at a time.");
        listFile.setRequired(false);
        this.cmdOptions.addOption(listFile);
    }

    public RetrievalToolConfig processCommandLine(String[] args) {
        RetrievalToolConfig config = null;
        try {
            config = this.processOptions(args);
        }
        catch (ParseException e) {
            this.printHelp(e.getMessage());
        }
        RetrievalConfig.setWorkDir(config.getWorkDir());
        config.setWorkDir(RetrievalConfig.getWorkDir());
        return config;
    }

    protected RetrievalToolConfig processOptions(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.cmdOptions, args);
        RetrievalToolConfig config = new RetrievalToolConfig();
        config.setContext(DEFAULT_CONTEXT);
        config.setHost(cmd.getOptionValue("h"));
        config.setUsername(cmd.getOptionValue("u"));
        if (null != cmd.getOptionValue("p")) {
            config.setPassword(cmd.getOptionValue("p"));
        } else if (null != this.getPasswordEnvVariable()) {
            config.setPassword(this.getPasswordEnvVariable());
        } else {
            ConsolePrompt console = this.getConsole();
            if (null == console) {
                this.printHelp("You must either specify a password in the command line or specify the DURACLOUD_PASSWORD environmental variable.");
            } else {
                char[] password = console.readPassword("DuraCloud password: ", new Object[0]);
                config.setPassword(new String(password));
            }
        }
        if (cmd.hasOption("r")) {
            try {
                config.setPort(Integer.valueOf(cmd.getOptionValue("r")));
            }
            catch (NumberFormatException e) {
                throw new ParseException("The value for port (-r) must be a number.");
            }
        } else {
            config.setPort(443);
        }
        if (cmd.hasOption("i")) {
            config.setStoreId(cmd.getOptionValue("i"));
        }
        if (!cmd.hasOption("s") && !cmd.hasOption("a")) {
            throw new ParseException("Either a list of spaces (-s) should be provided or the all spaces flag (-a) must be set.");
        }
        if (cmd.hasOption("s")) {
            String[] spaces = cmd.getOptionValues("s");
            ArrayList<String> spacesList = new ArrayList<String>();
            for (String space : spaces) {
                if (space == null || space.equals("")) continue;
                spacesList.add(space);
            }
            config.setSpaces(spacesList);
        }
        if (cmd.hasOption("a")) {
            config.setAllSpaces(true);
        } else {
            config.setAllSpaces(false);
        }
        File contentDir = new File(cmd.getOptionValue("c"));
        if (contentDir.exists()) {
            if (!contentDir.isDirectory()) {
                throw new ParseException("Content Dir paramter must provide the path to a directory.");
            }
        } else {
            contentDir.mkdirs();
        }
        contentDir.setWritable(true);
        config.setContentDir(contentDir);
        if (cmd.hasOption("w")) {
            File workDir = new File(cmd.getOptionValue("w"));
            if (workDir.exists()) {
                if (!workDir.isDirectory()) {
                    throw new ParseException("Work Dir parameter must provide the path to a directory.");
                }
            } else {
                workDir.mkdirs();
            }
            workDir.setWritable(true);
            config.setWorkDir(workDir);
        } else {
            config.setWorkDir(null);
        }
        if (cmd.hasOption("o")) {
            config.setOverwrite(true);
        } else {
            config.setOverwrite(false);
        }
        if (cmd.hasOption("t")) {
            try {
                config.setNumThreads(Integer.valueOf(cmd.getOptionValue("t")));
            }
            catch (NumberFormatException e) {
                throw new ParseException("The value for threads (-t) must be a number.");
            }
        } else {
            config.setNumThreads(3);
        }
        if (cmd.hasOption("d")) {
            config.setApplyTimestamps(false);
        } else {
            config.setApplyTimestamps(true);
        }
        if (cmd.hasOption("l")) {
            config.setListOnly(true);
        } else {
            config.setListOnly(false);
        }
        if (cmd.hasOption("f")) {
            if (config.getSpaces() != null && config.getSpaces().size() > 1 || config.isAllSpaces()) {
                throw new ParseException("The 'list-file' option (-f) can only operate on one space at a time.");
            }
            if (config.isListOnly()) {
                throw new ParseException("The 'list-file' option (-f) can not be used at the same time with the 'list-only' option (-l).");
            }
            File listFile = new File(cmd.getOptionValue("f"));
            if (listFile.exists()) {
                config.setListFile(listFile);
            } else {
                throw new ParseException("The specified 'list-file' containing content IDs to retrieve does not exist.");
            }
        }
        return config;
    }

    private void printHelp(String message) {
        System.out.println("\n-----------------------\n" + message + "\n-----------------------\n");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Running Retrieval Tool", this.cmdOptions);
        System.exit(1);
    }

    protected String getPasswordEnvVariable() {
        return this.cmdLineUtil.getPasswordEnvVariable();
    }

    protected ConsolePrompt getConsole() {
        return this.cmdLineUtil.getConsole();
    }
}

