/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

import org.apache.commons.lang3.StringUtils;

public class ContentByteRange {
    private Long rangeStart = null;
    private Long rangeEnd = null;

    public ContentByteRange(String range) {
        this.parseRange(range);
    }

    public Long getRangeStart() {
        return this.rangeStart;
    }

    public Long getRangeEnd() {
        return this.rangeEnd;
    }

    protected void parseRange(String range) {
        String prefix = "bytes=";
        if (!range.startsWith(prefix) || StringUtils.containsNone((CharSequence)range, "-")) {
            throw new IllegalArgumentException(this.getUsage(range));
        }
        String byteRange = range.substring(prefix.length()).split(",")[0];
        try {
            this.setRangeStart(byteRange.substring(0, byteRange.indexOf("-")));
            this.setRangeEnd(byteRange.substring(byteRange.indexOf("-") + 1, byteRange.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.getUsage(range));
        }
        if (null == this.getRangeStart() && null == this.getRangeEnd()) {
            throw new IllegalArgumentException(this.getUsage(range));
        }
    }

    public String getUsage(String range) {
        return "The Range header value, when utilized, must be in the format 'bytes=X-Y', where X and Y are numerical values. The value provided (" + range + ") is not valid.";
    }

    private void setRangeStart(String rangeStart) {
        if (StringUtils.isNotEmpty(rangeStart)) {
            this.rangeStart = Long.valueOf(rangeStart);
        }
    }

    private void setRangeEnd(String rangeEnd) {
        if (StringUtils.isNotEmpty(rangeEnd)) {
            this.rangeEnd = Long.valueOf(rangeEnd);
        }
    }
}

