/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import java.io.File;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.duracloud.common.model.ContentItem;
import org.duracloud.common.retry.Retrier;
import org.duracloud.retrieval.mgmt.OutputWriter;
import org.duracloud.retrieval.mgmt.RetrievalWorker;
import org.duracloud.retrieval.source.RetrievalSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrievalManager
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(RetrievalManager.class);
    private RetrievalSource source;
    private File contentDir;
    private File workDir;
    private boolean overwrite;
    private ThreadPoolExecutor workerPool;
    private OutputWriter outWriter;
    private boolean createSpaceDir;
    private boolean applyTimestamps;
    private boolean complete;

    public RetrievalManager(RetrievalSource source, File contentDir, File workDir, boolean overwrite, int threads, OutputWriter outWriter, boolean createSpaceDir, boolean applyTimestamps) {
        this.logger.info("Starting Retrieval Manager with " + threads + " threads");
        this.source = source;
        this.contentDir = contentDir;
        this.workDir = workDir;
        this.overwrite = overwrite;
        this.outWriter = outWriter;
        this.createSpaceDir = createSpaceDir;
        this.applyTimestamps = applyTimestamps;
        this.workerPool = new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public void run() {
        try {
            while (!this.complete) {
                ContentItem contentItem = (ContentItem)new Retrier(5, 4000, 2).execute(() -> this.source.getNextContentItem());
                if (contentItem == null) {
                    break;
                }
                while (!this.retrieveContent(contentItem)) {
                    this.sleep(1000L);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to run to completion", ex);
        }
        finally {
            this.shutdown();
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean retrieveContent(ContentItem contentItem) {
        try {
            this.logger.debug("contentItem={}", (Object)contentItem);
            RetrievalWorker worker = new RetrievalWorker(contentItem, this.source, this.contentDir, this.overwrite, this.outWriter, this.createSpaceDir, this.applyTimestamps);
            this.workerPool.execute(worker);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    public void shutdown() {
        this.logger.info("Closing Retrieval Manager");
        this.workerPool.shutdown();
        try {
            this.workerPool.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

