/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.ApplicationConfig;
import org.duracloud.error.ContentStoreException;
import org.duracloud.retrieval.config.RetrievalToolConfig;
import org.duracloud.retrieval.mgmt.CSVFileOutputWriter;
import org.duracloud.retrieval.mgmt.OutputWriter;
import org.duracloud.retrieval.mgmt.RetrievalManager;
import org.duracloud.retrieval.mgmt.SpaceListManager;
import org.duracloud.retrieval.mgmt.StatusManager;
import org.duracloud.retrieval.source.DuraStoreSpecifiedRetrievalSource;
import org.duracloud.retrieval.source.DuraStoreStitchingRetrievalSource;
import org.duracloud.retrieval.source.RetrievalSource;
import org.duracloud.retrieval.util.StoreClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrievalTool {
    private static final String RETRIEVALTOOL_PROPERTIES = "retrievaltool.properties";
    private final Logger logger = LoggerFactory.getLogger(RetrievalTool.class);
    private RetrievalToolConfig retConfig;
    private ExecutorService executor;
    private OutputWriter outWriter;
    private RetrievalManager retManager;
    private RetrievalSource retSource;
    private String version;

    public RetrievalTool() {
        Properties props = ApplicationConfig.getPropsFromResource(RETRIEVALTOOL_PROPERTIES);
        this.version = props.getProperty("version");
    }

    protected void setRetrievalConfig(RetrievalToolConfig retConfig) {
        this.retConfig = retConfig;
        this.retConfig.setVersion(this.version);
    }

    private void startRetrievalManager(ContentStore contentStore) {
        this.retSource = this.getRetrievalSource(contentStore);
        this.outWriter = new CSVFileOutputWriter(this.retConfig.getWorkDir());
        boolean createSpaceDir = this.isCreateSpaceDir();
        boolean applyTimestamps = this.retConfig.isApplyTimestamps();
        this.retManager = new RetrievalManager(this.retSource, this.retConfig.getContentDir(), this.retConfig.getWorkDir(), this.retConfig.isOverwrite(), this.retConfig.getNumThreads(), this.outWriter, createSpaceDir, applyTimestamps);
        this.executor.execute(this.retManager);
    }

    private RetrievalSource getRetrievalSource(ContentStore contentStore) {
        if (this.retSource == null) {
            if (this.retConfig.getListFile() != null) {
                try {
                    ArrayList<String> specifiedIds = new ArrayList<String>();
                    BufferedReader br = new BufferedReader(new FileReader(this.retConfig.getListFile()));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        specifiedIds.add(line);
                    }
                    this.retSource = new DuraStoreSpecifiedRetrievalSource(contentStore, this.retConfig.getSpaces(), specifiedIds.iterator());
                }
                catch (FileNotFoundException fnfe) {
                    String error = "Error: file of content IDs specified using '-f' option does not exist.\nError Message: " + fnfe.getMessage();
                    throw new DuraCloudRuntimeException(error, fnfe);
                }
                catch (IOException ioe) {
                    String error = "Error: problem reading file of content IDs specified using '-f' option.\nError Message: " + ioe.getMessage();
                    throw new DuraCloudRuntimeException(error, ioe);
                }
            } else {
                this.retSource = new DuraStoreStitchingRetrievalSource(contentStore, this.retConfig.getSpaces(), this.retConfig.isAllSpaces());
            }
        }
        return this.retSource;
    }

    private boolean isCreateSpaceDir() {
        boolean createDir = this.retConfig.isAllSpaces();
        if (!createDir) {
            createDir = this.retConfig.getSpaces().size() > 1;
        }
        return createDir;
    }

    private void waitForExit() {
        StatusManager statusManager = StatusManager.getInstance();
        statusManager.setVersion(this.version);
        int loops = 0;
        while (!this.retManager.isComplete()) {
            if (loops >= 60) {
                System.out.println(statusManager.getPrintableStatus());
                loops = 0;
            } else {
                ++loops;
            }
            this.sleep(10000L);
        }
        this.logger.info("Shutting down the Retrieval Tool");
        this.outWriter.close();
        this.executor.shutdown();
        System.out.println("Retrieval Tool processing complete, final status:");
        System.out.println(statusManager.getPrintableStatus());
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startSpaceListManager(ContentStore contentStore) {
        List<String> spaces;
        if (this.retConfig.isAllSpaces()) {
            try {
                spaces = contentStore.getSpaces();
            }
            catch (ContentStoreException e) {
                String errorMsg = "Unable to get spaces list due to error: " + e.getMessage();
                throw new DuraCloudRuntimeException(errorMsg, e);
            }
        } else {
            spaces = this.retConfig.getSpaces();
        }
        SpaceListManager spaceListManager = new SpaceListManager(contentStore, this.retConfig.getContentDir(), spaces, this.retConfig.isOverwrite(), this.retConfig.getNumThreads());
        this.executor.execute(spaceListManager);
        while (!spaceListManager.isComplete()) {
            this.sleep(1000L);
        }
        this.executor.shutdown();
    }

    public void runRetrievalTool() {
        this.logger.info("Starting Retrieval Tool version " + this.version);
        this.logger.info("Running Retrieval Tool with configuration: " + this.retConfig.getPrintableConfig());
        System.out.print("\nStarting up the Retrieval Tool ...");
        System.out.println(this.retConfig.getPrintableConfig());
        StoreClientUtil clientUtil = new StoreClientUtil();
        try {
            ContentStore contentStore = clientUtil.createContentStore(this.retConfig.getHost(), this.retConfig.getPort(), this.retConfig.getContext(), this.retConfig.getUsername(), this.retConfig.getPassword(), this.retConfig.getStoreId());
            this.executor = Executors.newFixedThreadPool(1);
            if (this.retConfig.isListOnly()) {
                this.startSpaceListManager(contentStore);
            } else {
                this.startRetrievalManager(contentStore);
                System.out.println("... Startup Complete");
                System.out.println("The Retrieval Tool will exit when processing is complete. Status will be printed every 10 minutes.\n");
                this.waitForExit();
            }
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message != null && message.contains(" 401 ")) {
                System.out.println("Your username/password combination is invalid.  Please check your credentials and try again. ");
            } else {
                System.out.println("The retrievaltool failed to start successfully due to the following error: \n" + ex.getMessage());
            }
            System.exit(-1);
        }
    }
}

