/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.duracloud.chunk.util.ChunkUtil;
import org.duracloud.client.ContentStore;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.error.ContentStoreException;
import org.duracloud.manifest.ManifestFormatter;
import org.duracloud.manifest.impl.ManifestFormatterFactory;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.retrieval.source.DuraStoreStitchingRetrievalSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreSpecifiedRetrievalSource
extends DuraStoreStitchingRetrievalSource {
    private final Logger log = LoggerFactory.getLogger(DuraStoreSpecifiedRetrievalSource.class);
    private Iterator<String> specifiedContentIds;
    private ChunkUtil chunkUtil = null;

    public DuraStoreSpecifiedRetrievalSource(ContentStore store, List<String> singleSpaceList, Iterator<String> specifiedContentIds) {
        super(store, singleSpaceList, false);
        if (singleSpaceList == null) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must not be NULL.");
        }
        if (singleSpaceList.isEmpty()) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must contain 1 space ID.");
        }
        if (singleSpaceList.size() > 1) {
            throw new DuraCloudRuntimeException("The space list specified for DuraStoreSpecifiedRetrievelSource must contain only 1 space ID.");
        }
        this.chunkUtil = new ChunkUtil();
        this.specifiedContentIds = specifiedContentIds;
        this.reviewSpecifiedContentIdsForChunkedContent(singleSpaceList);
    }

    private void reviewSpecifiedContentIdsForChunkedContent(List<String> singleSpaceList) {
        this.log.debug("enter reviewSpecifiedContentIdsForChunkedContent()");
        System.out.println("Reviewing space manifest for content IDs in list-file.");
        ArrayList<String> retrievalContentIds = new ArrayList<String>();
        while (this.specifiedContentIds.hasNext()) {
            String specifiedContentId = this.specifiedContentIds.next();
            retrievalContentIds.add(specifiedContentId);
        }
        this.log.debug("total contentIds in list-file: " + retrievalContentIds.size());
        HashMap<String, String> retrievalSpaceContentIds = new HashMap<String, String>();
        Iterator<String> retrievalSpaceIds = this.verifySpaceIds(singleSpaceList);
        if (retrievalSpaceIds.hasNext()) {
            String currentRetrievalSpaceId = retrievalSpaceIds.next();
            this.log.debug("searching for contentIds in space: " + currentRetrievalSpaceId);
            try {
                InputStream manifest = this.contentStore.getManifest(currentRetrievalSpaceId, ManifestFormat.TSV);
                ManifestFormatter formatter = new ManifestFormatterFactory().create(ManifestFormat.TSV);
                String header = formatter.getHeader();
                BufferedReader reader = new BufferedReader(new InputStreamReader(manifest));
                String line = null;
                ManifestItem item = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().length() == 0 || line.equals(header)) continue;
                        try {
                            item = formatter.parseLine(line);
                        }
                        catch (ParseException e) {
                            throw new IOException(e);
                        }
                        String spaceContentId = item.getContentId();
                        if (this.chunkUtil.isChunkManifest(spaceContentId)) {
                            String rootContentId = this.chunkUtil.preChunkedContentId(spaceContentId);
                            this.log.debug("found chunk manifest for contentId from list-file: " + spaceContentId);
                            retrievalSpaceContentIds.put(rootContentId, spaceContentId);
                            continue;
                        }
                        retrievalSpaceContentIds.put(spaceContentId, null);
                    }
                }
                catch (IOException ex) {
                    this.log.error("Error reading space manifest.");
                }
            }
            catch (ContentStoreException cse) {
                this.log.error("Unable to retrieve space manifest. If files-list.txt contains chunked files and the retrieval fails the local content dir will need to be empty.");
            }
        }
        ArrayList<String> retrievalContentIdsFinal = new ArrayList<String>();
        for (String retrievalContentId : retrievalContentIds) {
            if (retrievalSpaceContentIds.containsKey(retrievalContentId)) {
                if (null != retrievalSpaceContentIds.get(retrievalContentId)) {
                    String chunkManifestContentId = (String)retrievalSpaceContentIds.get(retrievalContentId);
                    this.log.debug("replacing {} with chunk manifest {} in list of contentIds to retrieve.", (Object)retrievalContentId, (Object)chunkManifestContentId);
                    retrievalContentIdsFinal.add(chunkManifestContentId);
                    continue;
                }
                retrievalContentIdsFinal.add(retrievalContentId);
                continue;
            }
            this.log.warn("Content ID {} in list-file is not present in the retrieval space manifest.", (Object)retrievalContentId);
            retrievalContentIdsFinal.add(retrievalContentId);
        }
        System.out.println("Finished reviewing space manifest for contentIDs in list-file.\n");
        this.specifiedContentIds = retrievalContentIdsFinal.iterator();
    }

    @Override
    protected void getNextSpace() {
        if (this.spaceIds.hasNext()) {
            this.currentSpaceId = (String)this.spaceIds.next();
            this.currentContentList = this.specifiedContentIds;
        }
    }
}

