/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AfterInvocationProvider;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.intercept.AfterInvocationManager;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AfterInvocationProviderManager
implements AfterInvocationManager,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(AfterInvocationProviderManager.class);
    private List<AfterInvocationProvider> providers;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
    }

    private void checkIfValidList(List<?> listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AfterInvocationProviders is required");
        }
    }

    @Override
    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        Object result = returnedObject;
        for (AfterInvocationProvider provider : this.providers) {
            result = provider.decide(authentication, object, config, result);
        }
        return result;
    }

    public List<AfterInvocationProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<?> newList) {
        this.checkIfValidList(newList);
        this.providers = new ArrayList<AfterInvocationProvider>(newList.size());
        for (Object currentObject : newList) {
            Assert.isInstanceOf(AfterInvocationProvider.class, currentObject, "AfterInvocationProvider " + currentObject.getClass().getName() + " must implement AfterInvocationProvider");
            this.providers.add((AfterInvocationProvider)currentObject);
        }
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        for (AfterInvocationProvider provider : this.providers) {
            if (logger.isDebugEnabled()) {
                logger.debug("Evaluating " + attribute + " against " + provider);
            }
            if (!provider.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        for (AfterInvocationProvider provider : this.providers) {
            if (provider.supports(clazz)) continue;
            return false;
        }
        return true;
    }
}

