/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.manifest.impl;

import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.manifest.ManifestFormatter;
import org.duracloud.manifest.impl.BagitManifestFormatter;
import org.duracloud.manifest.impl.TsvManifestFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFormatterFactory {
    private Logger log = LoggerFactory.getLogger(ManifestFormatterFactory.class);

    public ManifestFormatter create(ManifestFormat format) {
        return switch (format) {
            case ManifestFormat.BAGIT -> new BagitManifestFormatter();
            case ManifestFormat.TSV -> new TsvManifestFormatter();
            default -> {
                String err = "Unexpected format: " + format.name();
                this.log.error(err);
                throw new RuntimeException(err);
            }
        };
    }
}

