/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.duracloud.chunk.util.ChunkUtil;
import org.duracloud.client.ContentStore;
import org.duracloud.common.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceListWorker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(SpaceListWorker.class);
    private ContentStore contentStore;
    private String spaceId;
    private File contentDir;
    private File outputFile;
    private boolean overwrite;
    private ChunkUtil chunkUtil;

    public SpaceListWorker(ContentStore contentStore, String spaceId, File contentDir, boolean overwrite) {
        this.contentStore = contentStore;
        this.spaceId = spaceId;
        this.contentDir = contentDir;
        this.overwrite = overwrite;
        this.chunkUtil = new ChunkUtil();
    }

    @Override
    public void run() {
        this.createSpaceListFile();
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    protected void createSpaceListFile() {
        try {
            String providerType = this.contentStore.getStorageProviderType().toLowerCase();
            this.outputFile = new File(this.contentDir, this.spaceId + "-content-listing-" + providerType + ".txt");
            if (this.outputFile.exists() && this.overwrite) {
                this.outputFile.delete();
            } else if (this.outputFile.exists() && !this.overwrite) {
                this.outputFile = new File(this.contentDir, this.spaceId + "-content-listing-" + providerType + "-" + DateUtil.nowPlain() + ".txt");
            }
            this.logger.info("Writing space '" + this.spaceId + "' listing to: " + this.outputFile.getAbsolutePath());
            Iterator<String> contentIterator = this.contentStore.getSpaceContents(this.spaceId);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));){
                while (contentIterator.hasNext()) {
                    String contentId = contentIterator.next();
                    if (!this.chunkUtil.isChunk(contentId) && !this.chunkUtil.isChunkManifest(contentId)) {
                        writer.write(contentId + System.lineSeparator());
                        continue;
                    }
                    if (!this.chunkUtil.isChunkManifest(contentId)) continue;
                    writer.write(this.chunkUtil.preChunkedContentId(contentId) + System.lineSeparator());
                }
            }
        }
        catch (Exception e) {
            String error = "Failed to retrieve content listing for space: '" + this.spaceId + "'.  Error message: " + e.getMessage();
            System.err.println(error);
            this.logger.error(error, e);
        }
    }
}

