/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.s3.AmazonS3Client;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableStreamingTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(EnableStreamingTaskRunner.class);
    public static final String TASK_NAME = "enable-streaming";

    public EnableStreamingTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, CloudFrontService cfService) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfService = cfService;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        String results;
        String spaceId = this.getSpaceId(taskParameters);
        this.log.info("Performing enable-streaming task on space " + spaceId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        String domainName = null;
        String distId = null;
        String oaIdentityId = null;
        try {
            StreamingDistribution existingDist = this.getExistingDistribution(bucketName);
            if (existingDist != null) {
                distId = existingDist.getId();
                oaIdentityId = this.getDistributionOriginAccessId(distId);
                if (oaIdentityId != null) {
                    if (!existingDist.isEnabled()) {
                        this.cfService.updateStreamingDistributionConfig(distId, null, null, null, true, null);
                    }
                    domainName = existingDist.getDomainName();
                } else {
                    distId = null;
                }
            }
            if (distId == null) {
                oaIdentityId = this.getOriginAccessId();
                S3Origin origin = new S3Origin(CloudFrontService.sanitizeS3BucketName((String)bucketName), oaIdentityId);
                StreamingDistribution dist = this.cfService.createStreamingDistribution((Origin)origin, null, null, null, true, null, false, null);
                domainName = dist.getDomainName();
                distId = dist.getId();
            }
            this.setBucketAccessPolicy(bucketName, oaIdentityId);
            Map spaceProps = this.s3Provider.getSpaceProperties(spaceId);
            spaceProps.put("streaming-host", domainName);
            this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
            results = "Enable Streaming Task completed successfully";
        }
        catch (CloudFrontServiceException e) {
            this.log.warn("Error encountered running enable-streaming task: " + e.getMessage(), (Throwable)e);
            results = "Enable Streaming Task failed due to: " + e.getMessage();
        }
        HashMap<String, String> returnInfo = new HashMap<String, String>();
        returnInfo.put("domain-name", domainName);
        returnInfo.put("results", results);
        String toReturn = SerializationUtil.serializeMap(returnInfo);
        this.log.debug("Result of enable-streaming task: " + toReturn);
        return toReturn;
    }

    private String getOriginAccessId() throws CloudFrontServiceException {
        String oaId = this.getExistingOriginAccessId();
        if (oaId != null) {
            return oaId;
        }
        OriginAccessIdentity oaIdentity = this.cfService.createOriginAccessIdentity(null, "id");
        return oaIdentity.getId();
    }

    private String getExistingOriginAccessId() throws CloudFrontServiceException {
        OriginAccessIdentity oaID;
        List oaiList = this.cfService.getOriginAccessIdentityList();
        if (oaiList != null && oaiList.size() > 0 && (oaID = (OriginAccessIdentity)oaiList.iterator().next()) != null) {
            return oaID.getId();
        }
        return null;
    }

    private void setBucketAccessPolicy(String bucketName, String oaIdentityId) throws CloudFrontServiceException {
        oaIdentityId = StringUtils.removeStart((String)oaIdentityId, (String)"origin-access-identity/cloudfront/");
        OriginAccessIdentity oaIdentity = this.cfService.getOriginAccessIdentity(oaIdentityId);
        String s3UserId = oaIdentity.getS3CanonicalUserId();
        StringBuilder policyText = new StringBuilder();
        policyText.append("{\"Version\":\"2012-10-17\",");
        policyText.append("\"Id\":\"PolicyForCloudFrontPrivateContent\",");
        policyText.append("\"Statement\":[{");
        policyText.append("\"Sid\":\"Grant CloudFront access to private content\",");
        policyText.append("\"Effect\":\"Allow\",");
        policyText.append("\"Principal\":{\"CanonicalUser\":\"" + s3UserId + "\"},");
        policyText.append("\"Action\":\"s3:GetObject\",");
        policyText.append("\"Resource\":\"arn:aws:s3:::" + bucketName + "/*\"");
        policyText.append("}]}");
        this.s3Client.setBucketPolicy(bucketName, policyText.toString());
    }
}

