/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.storage;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.HashMap;
import java.util.Iterator;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;

public abstract class BaseStorageClassTaskRunner
implements TaskRunner {
    private static final int MAX_FAILURES = 500;
    protected StorageProvider s3Provider;
    protected S3StorageProvider unwrappedS3Provider;
    protected AmazonS3Client s3Client;

    protected abstract StorageClass getStorageClass();

    public abstract String getName();

    public String performTask(String taskParameters) {
        String spaceId = taskParameters;
        if (spaceId == null) {
            throw new RuntimeException("Space ID is required to set storage class");
        }
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        Iterator contentItems = this.s3Provider.getSpaceContents(spaceId, null);
        long successful = 0L;
        HashMap<String, String> unsuccessful = new HashMap<String, String>();
        boolean broken = false;
        while (contentItems.hasNext()) {
            String contentId = (String)contentItems.next();
            try {
                this.s3Client.changeObjectStorageClass(bucketName, contentId, this.getStorageClass());
                ++successful;
            }
            catch (Exception e) {
                unsuccessful.put(contentId, e.getMessage());
                if (unsuccessful.size() <= 500) continue;
                broken = true;
                break;
            }
        }
        String results = successful + " items updated successfully\n";
        if (unsuccessful.size() > 0) {
            results = results + unsuccessful.size() + " items failed:\n";
            for (String failedId : unsuccessful.keySet()) {
                results = results + "    " + failedId + " :" + (String)unsuccessful.get(failedId) + "\n";
            }
            if (broken) {
                results = results + "Max failures reached prior to task completion, this task did not complete";
            }
        }
        return results;
    }
}

