/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.s3.AmazonS3Client;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableStreamingTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(DisableStreamingTaskRunner.class);
    public static final String TASK_NAME = "disable-streaming";

    public DisableStreamingTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, CloudFrontService cfService) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfService = cfService;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        String results;
        String spaceId = this.getSpaceId(taskParameters);
        this.log.info("Performing disable-streaming task on space " + spaceId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        this.removeStreamingHostFromSpaceProps(spaceId);
        try {
            StreamingDistribution existingDist = this.getExistingDistribution(bucketName);
            if (existingDist == null) {
                throw new RuntimeException("No streaming distribution exists for space " + spaceId);
            }
            this.s3Client.deleteBucketPolicy(bucketName);
            results = "Disable Streaming Task completed successfully";
        }
        catch (CloudFrontServiceException e) {
            this.log.warn("Error encountered running disable-streaming task: " + e.getMessage(), (Throwable)e);
            results = "Disable Streaming Task failed due to: " + e.getMessage();
        }
        this.log.debug("Result of disable-streaming task: " + results);
        return results;
    }
}

