/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.s3.AmazonS3Client;
import java.util.List;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStreamingTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(DeleteStreamingTaskRunner.class);
    private static final String TASK_NAME = "delete-streaming";

    public DeleteStreamingTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, CloudFrontService cfService) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfService = cfService;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        String results;
        String spaceId = this.getSpaceId(taskParameters);
        this.log.info("Performing delete-streaming task on space " + spaceId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        this.removeStreamingHostFromSpaceProps(spaceId);
        this.s3Client.deleteBucketPolicy(bucketName);
        try {
            List<StreamingDistribution> existingDists = this.getAllExistingDistributions(bucketName);
            if (existingDists != null && existingDists.size() > 0) {
                for (StreamingDistribution existingDist : existingDists) {
                    String distId = existingDist.getId();
                    if (existingDist.isEnabled()) {
                        this.cfService.disableStreamingDistributionForDeletion(distId);
                        this.waitForDisabled(distId);
                    }
                    this.cfService.deleteStreamingDistribution(distId);
                }
            } else {
                throw new RuntimeException("No streaming distribution exists for space " + spaceId);
            }
            results = "Delete Streaming Task completed successfully";
        }
        catch (CloudFrontServiceException e) {
            this.log.warn("Error encountered running delete-streaming task: " + e.getMessage(), (Throwable)e);
            results = "Delete Streaming Task failed due to: " + e.getMessage();
        }
        this.log.debug("Result of delete-streaming task: " + results);
        return results;
    }

    private void waitForDisabled(String distId) throws CloudFrontServiceException {
        long maxTime = 900000L;
        long start = System.currentTimeMillis();
        StreamingDistribution dist = this.cfService.getStreamingDistributionInfo(distId);
        while (!dist.isDeployed()) {
            if (System.currentTimeMillis() < start + maxTime) {
                this.sleep(10000L);
                dist = this.cfService.getStreamingDistributionInfo(distId);
                continue;
            }
            String error = "Timeout Reached waiting for distribution to be disabled. Please wait a few minutes and try again.";
            throw new CloudFrontServiceException(error);
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.log.warn("sleep interrupted");
        }
    }
}

