/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.CloudFrontUrlSigner;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import java.io.File;
import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import java.util.Calendar;
import java.util.Date;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskResult;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSignedUrlTaskRunner
extends BaseStreamingTaskRunner {
    public static final int DEFAULT_MINUTES_TO_EXPIRE = 480;
    private final Logger log = LoggerFactory.getLogger(GetSignedUrlTaskRunner.class);
    private static final String TASK_NAME = "get-signed-url";

    public GetSignedUrlTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonCloudFrontClient cfClient, String cfKeyId, String cfKeyPath) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.cfClient = cfClient;
        this.cfKeyId = cfKeyId;
        this.cfKeyPath = cfKeyPath;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        GetSignedUrlTaskParameters taskParams = GetSignedUrlTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        String contentId = taskParams.getContentId();
        String resourcePrefix = taskParams.getResourcePrefix();
        String ipAddress = taskParams.getIpAddress();
        int minutesToExpire = taskParams.getMinutesToExpire();
        if (minutesToExpire <= 0) {
            minutesToExpire = 480;
        }
        this.log.info("Performing get-signed-url task with parameters: spaceId=" + spaceId + ", contentId=" + contentId + ", resourcePrefix=" + resourcePrefix + ", minutesToExpire=" + minutesToExpire + ", ipAddress=" + ipAddress);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        GetSignedUrlTaskResult taskResult = new GetSignedUrlTaskResult();
        this.checkThatStreamingServiceIsEnabled(this.s3Provider, spaceId, TASK_NAME);
        this.checkThatContentIdExists(this.s3Provider, spaceId, contentId, TASK_NAME);
        StreamingDistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (null == existingDist) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-signed-url task can only be used after a space has been configured to enable secure streaming. Use enable-streaming to enable secure streaming on this space.");
        }
        String domainName = existingDist.getDomainName();
        if (existingDist.getTrustedSigners().getItems().isEmpty()) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-signed-url task cannot be used to request a stream from an open distribution. Use get-url instead.");
        }
        if (null == resourcePrefix) {
            resourcePrefix = "";
        }
        Calendar expireCalendar = Calendar.getInstance();
        expireCalendar.add(12, minutesToExpire);
        try {
            String signedUrl = CloudFrontUrlSigner.getSignedURLWithCustomPolicy((CloudFrontUrlSigner.Protocol)CloudFrontUrlSigner.Protocol.rtmp, (String)domainName, (File)new File(this.cfKeyPath), (String)contentId, (String)this.cfKeyId, (Date)expireCalendar.getTime(), null, (String)ipAddress);
            taskResult.setSignedUrl("rtmp://" + domainName + "/cfx/st/" + resourcePrefix + signedUrl);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException("Error encountered attempting to sign URL for task get-signed-url: " + e.getMessage(), e);
        }
        String toReturn = taskResult.serialize();
        this.log.info("Result of get-signed-url task: " + toReturn);
        return toReturn;
    }
}

