/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3storage;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.s3.AmazonS3Client;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.storage.error.StorageException;

public class S3ProviderUtil {
    private static Map<String, AmazonS3Client> s3Clients = new HashMap<String, AmazonS3Client>();
    private static Map<String, AmazonCloudFrontClient> cloudFrontClients = new HashMap<String, AmazonCloudFrontClient>();

    public static AmazonS3Client getAmazonS3Client(String accessKey, String secretKey) {
        AmazonS3Client client = s3Clients.get(S3ProviderUtil.key(accessKey, secretKey));
        if (null == client) {
            client = S3ProviderUtil.newS3Client(accessKey, secretKey);
            s3Clients.put(S3ProviderUtil.key(accessKey, secretKey), client);
        }
        return client;
    }

    private static String key(String accessKey, String secretKey) {
        return accessKey + secretKey;
    }

    private static AmazonS3Client newS3Client(String accessKey, String secretKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        try {
            return new AmazonS3Client((AWSCredentials)awsCredentials);
        }
        catch (AmazonServiceException e) {
            String err = "Could not create connection to Amazon S3 due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    public static AmazonCloudFrontClient getAmazonCloudFrontClient(String accessKey, String secretKey) {
        AmazonCloudFrontClient client = cloudFrontClients.get(S3ProviderUtil.key(accessKey, secretKey));
        if (null == client) {
            client = S3ProviderUtil.newAmazonCloudFrontClient(accessKey, secretKey);
            cloudFrontClients.put(S3ProviderUtil.key(accessKey, secretKey), client);
        }
        return client;
    }

    private static AmazonCloudFrontClient newAmazonCloudFrontClient(String accessKey, String secretKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        try {
            return new AmazonCloudFrontClient((AWSCredentials)awsCredentials);
        }
        catch (AmazonServiceException e) {
            String err = "Could not create connection to Amazon CloudFront due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    public static String createNewBucketName(String accessKeyId, String spaceId) {
        String bucketName = accessKeyId + "." + spaceId;
        bucketName = bucketName.toLowerCase();
        bucketName = bucketName.replaceAll("[^a-z0-9-.]", "-");
        while (bucketName.contains("--") || bucketName.contains("..") || bucketName.contains("-.") || bucketName.contains(".-")) {
            bucketName = bucketName.replaceAll("[-]+", "-");
            bucketName = bucketName.replaceAll("[.]+", ".");
            bucketName = bucketName.replaceAll("-[.]", "-");
            bucketName = bucketName.replaceAll("[.]-", ".");
        }
        if (bucketName.length() > 63) {
            bucketName = bucketName.substring(0, 63);
        }
        while (bucketName.endsWith("-") || bucketName.endsWith(".")) {
            bucketName = bucketName.substring(0, bucketName.length() - 1);
        }
        return bucketName;
    }
}

