/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.storage;

import com.amazonaws.services.s3.model.StorageClass;
import java.util.Arrays;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storage.StoragePolicy;
import org.duracloud.s3storageprovider.dto.SetStoragePolicyTaskParameters;
import org.duracloud.storage.provider.TaskRunner;

public class SetStoragePolicyTaskRunner
implements TaskRunner {
    private static final String TASK_NAME = "set-storage-policy";
    protected S3StorageProvider unwrappedS3Provider;

    public SetStoragePolicyTaskRunner(S3StorageProvider unwrappedS3Provider) {
        this.unwrappedS3Provider = unwrappedS3Provider;
    }

    public String getName() {
        return TASK_NAME;
    }

    public String performTask(String taskParameters) {
        StorageClass storageClass;
        SetStoragePolicyTaskParameters taskParams = SetStoragePolicyTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        int daysToTransition = taskParams.getDaysToTransition();
        try {
            storageClass = StorageClass.fromValue((String)taskParams.getStorageClass());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot set storage policy due to invalid storage class. The valid storage class options are: " + Arrays.asList(StorageClass.values()));
        }
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        StoragePolicy storagePolicy = new StoragePolicy(storageClass, daysToTransition);
        this.unwrappedS3Provider.setSpaceLifecycle(bucketName, storagePolicy.getBucketLifecycleConfig());
        return "Successfully set storage policy on space " + spaceId + " to move content to " + storageClass.name() + " after " + daysToTransition + " days";
    }
}

