/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaminghls;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentity;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.Distribution;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.ItemSelection;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.Method;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.OriginProtocolPolicy;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskResult;
import org.duracloud.s3task.streaminghls.BaseHlsTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableHlsTaskRunner
extends BaseHlsTaskRunner {
    private final Logger log = LoggerFactory.getLogger(EnableHlsTaskRunner.class);
    private static final String TASK_NAME = "enable-hls";

    public EnableHlsTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, AmazonCloudFrontClient cfClient, String cfAccountId, String dcHost) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfClient = cfClient;
        this.cfAccountId = cfAccountId;
        this.dcHost = dcHost;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        EnableStreamingTaskParameters taskParams = EnableStreamingTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        boolean secure = taskParams.isSecure();
        List allowedOrigins = taskParams.getAllowedOrigins();
        this.log.info("Performing enable-hls task on space " + spaceId + ". Secure streaming set to " + secure);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        String domainName = null;
        String distId = null;
        String oaIdentityId = this.getOriginAccessId();
        EnableStreamingTaskResult taskResult = new EnableStreamingTaskResult();
        DistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (existingDist != null) {
            boolean existingSecure;
            boolean bl = existingSecure = !existingDist.getDefaultCacheBehavior().getTrustedSigners().getItems().isEmpty();
            if (secure && !existingSecure || !secure && existingSecure) {
                throw new UnsupportedTaskException(TASK_NAME, "The space " + spaceId + " is already configured to stream as " + (secure ? "OPEN" : "SECURE") + " and cannot be updated to stream as " + (secure ? "SECURE" : "OPEN") + ". To do this, you must first execute the " + "delete-hls" + " task.");
            }
            distId = existingDist.getId();
            if (!existingDist.isEnabled().booleanValue()) {
                this.setDistributionState(distId, true);
            }
            domainName = existingDist.getDomainName();
        } else {
            Origins origins;
            S3OriginConfig s3OriginConfig = new S3OriginConfig().withOriginAccessIdentity("origin-access-identity/cloudfront/" + oaIdentityId);
            Origin s3Origin = new Origin().withDomainName(bucketName + ".s3.amazonaws.com").withS3OriginConfig(s3OriginConfig).withId("S3-" + bucketName);
            TrustedSigners signers = new TrustedSigners();
            if (secure) {
                signers.setItems(Collections.singletonList(this.cfAccountId));
                signers.setEnabled(Boolean.valueOf(true));
                signers.setQuantity(Integer.valueOf(1));
            } else {
                signers.setEnabled(Boolean.valueOf(false));
                signers.setQuantity(Integer.valueOf(0));
            }
            DefaultCacheBehavior defaultCacheBehavior = new DefaultCacheBehavior();
            defaultCacheBehavior.setTrustedSigners(signers);
            defaultCacheBehavior.setViewerProtocolPolicy(ViewerProtocolPolicy.RedirectToHttps);
            defaultCacheBehavior.setAllowedMethods(new AllowedMethods().withItems(new Method[]{Method.GET, Method.HEAD, Method.OPTIONS}).withQuantity(Integer.valueOf(3)));
            defaultCacheBehavior.setForwardedValues(new ForwardedValues().withQueryString(Boolean.valueOf(false)).withCookies(new CookiePreference().withForward(ItemSelection.None)).withHeaders(new Headers().withItems(new String[]{"Origin", "Access-Control-Request-Headers", "Access-Control-Request-Method"}).withQuantity(Integer.valueOf(3))));
            defaultCacheBehavior.setMinTTL(Long.valueOf(0L));
            defaultCacheBehavior.setTargetOriginId(s3Origin.getId());
            CacheBehaviors cacheBehaviors = new CacheBehaviors();
            if (secure) {
                CustomOriginConfig cookiesOriginConfig = new CustomOriginConfig().withOriginProtocolPolicy(OriginProtocolPolicy.HttpsOnly).withHTTPPort(Integer.valueOf(80)).withHTTPSPort(Integer.valueOf(443));
                String getCookiesPath = "/durastore/aux";
                String cookiesOriginId = "Custom origin - " + this.dcHost + getCookiesPath;
                Origin cookiesOrigin = new Origin().withDomainName(this.dcHost).withOriginPath(getCookiesPath).withId(cookiesOriginId).withCustomOriginConfig(cookiesOriginConfig);
                origins = new Origins().withItems(new Origin[]{s3Origin, cookiesOrigin}).withQuantity(Integer.valueOf(2));
                CookiePreference cookiePreference = new CookiePreference().withForward(ItemSelection.All);
                CacheBehavior cookiesCacheBehavior = new CacheBehavior().withPathPattern("/cookies").withTargetOriginId(cookiesOriginId).withViewerProtocolPolicy(ViewerProtocolPolicy.RedirectToHttps).withAllowedMethods(new AllowedMethods().withItems(new Method[]{Method.GET, Method.HEAD}).withQuantity(Integer.valueOf(2))).withForwardedValues(new ForwardedValues().withQueryString(Boolean.valueOf(true)).withCookies(cookiePreference)).withTrustedSigners(new TrustedSigners().withEnabled(Boolean.valueOf(false)).withQuantity(Integer.valueOf(0))).withMinTTL(Long.valueOf(0L));
                cacheBehaviors = cacheBehaviors.withItems(new CacheBehavior[]{cookiesCacheBehavior}).withQuantity(Integer.valueOf(1));
            } else {
                origins = new Origins().withItems(new Origin[]{s3Origin}).withQuantity(Integer.valueOf(1));
            }
            DistributionConfig distributionConfig = new DistributionConfig().withCallerReference("" + System.currentTimeMillis()).withOrigins(origins).withEnabled(Boolean.valueOf(true)).withComment("HLS streaming for space: " + spaceId).withDefaultCacheBehavior(defaultCacheBehavior);
            if (secure) {
                distributionConfig.setCacheBehaviors(cacheBehaviors);
            }
            Distribution dist = this.cfClient.createDistribution(new CreateDistributionRequest(distributionConfig)).getDistribution();
            domainName = dist.getDomainName();
        }
        this.setBucketAccessPolicy(bucketName, oaIdentityId);
        this.setCorsPolicy(bucketName, allowedOrigins, this.dcHost);
        Map spaceProps = this.s3Provider.getSpaceProperties(spaceId);
        spaceProps.put("hls-streaming-host", domainName);
        spaceProps.put("hls-streaming-type", secure ? BaseHlsTaskRunner.STREAMING_TYPE.SECURE.name() : BaseHlsTaskRunner.STREAMING_TYPE.OPEN.name());
        this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
        taskResult.setResult("enable-hls task completed successfully");
        taskResult.setStreamingHost(domainName);
        String toReturn = taskResult.serialize();
        this.log.info("Result of enable-hls task: " + toReturn);
        return toReturn;
    }

    private String getOriginAccessId() {
        String oaId = this.getExistingOriginAccessId();
        if (oaId != null) {
            return oaId;
        }
        return this.cfClient.createCloudFrontOriginAccessIdentity(new CreateCloudFrontOriginAccessIdentityRequest(new CloudFrontOriginAccessIdentityConfig().withCallerReference("" + System.currentTimeMillis()).withComment("DuraCloud Origin Access ID"))).getCloudFrontOriginAccessIdentity().getId();
    }

    private String getExistingOriginAccessId() {
        List oaiList = this.cfClient.listCloudFrontOriginAccessIdentities(new ListCloudFrontOriginAccessIdentitiesRequest()).getCloudFrontOriginAccessIdentityList().getItems();
        if (oaiList != null && oaiList.size() > 0) {
            return ((CloudFrontOriginAccessIdentitySummary)oaiList.iterator().next()).getId();
        }
        return null;
    }

    private void setBucketAccessPolicy(String bucketName, String oaIdentityId) {
        CloudFrontOriginAccessIdentity cfOAIdentity = this.cfClient.getCloudFrontOriginAccessIdentity(new GetCloudFrontOriginAccessIdentityRequest(oaIdentityId)).getCloudFrontOriginAccessIdentity();
        String s3UserId = cfOAIdentity.getS3CanonicalUserId();
        StringBuilder policyText = new StringBuilder();
        policyText.append("{\"Version\":\"2012-10-17\",");
        policyText.append("\"Id\":\"PolicyForCloudFrontPrivateContent\",");
        policyText.append("\"Statement\":[{");
        policyText.append("\"Sid\":\"Grant CloudFront access to private content\",");
        policyText.append("\"Effect\":\"Allow\",");
        policyText.append("\"Principal\":{\"CanonicalUser\":\"" + s3UserId + "\"},");
        policyText.append("\"Action\":\"s3:GetObject\",");
        policyText.append("\"Resource\":\"arn:aws:s3:::" + bucketName + "/*\"");
        policyText.append("}]}");
        this.s3Client.setBucketPolicy(bucketName, policyText.toString());
    }

    private void setCorsPolicy(String bucketName, List<String> allowedOrigins, String dcHost) {
        if (null == allowedOrigins || allowedOrigins.isEmpty()) {
            allowedOrigins = new ArrayList<String>();
            allowedOrigins.add("https://*");
        } else {
            allowedOrigins.add("https://" + dcHost);
        }
        ArrayList<CORSRule> corsRules = new ArrayList<CORSRule>();
        for (String allowedOrigin : allowedOrigins) {
            CORSRule corsRule = new CORSRule();
            corsRule.setAllowedOrigins(new String[]{allowedOrigin});
            corsRule.setAllowedMethods(new CORSRule.AllowedMethods[]{CORSRule.AllowedMethods.GET, CORSRule.AllowedMethods.HEAD});
            corsRule.setMaxAgeSeconds(3000);
            corsRule.setAllowedHeaders(new String[]{"*"});
            corsRules.add(corsRule);
        }
        BucketCrossOriginConfiguration corsConfig = new BucketCrossOriginConfiguration().withRules(corsRules);
        this.s3Client.setBucketCrossOriginConfiguration(bucketName, corsConfig);
    }
}

