/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import com.amazonaws.services.s3.AmazonS3;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.DisableStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.DisableStreamingTaskResult;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableStreamingTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(DisableStreamingTaskRunner.class);
    private static final String TASK_NAME = "disable-streaming";

    public DisableStreamingTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3 s3Client, AmazonCloudFrontClient cfClient) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfClient = cfClient;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        DisableStreamingTaskParameters taskParams = DisableStreamingTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        this.log.info("Performing disable-streaming task on space " + spaceId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        DisableStreamingTaskResult taskResult = new DisableStreamingTaskResult();
        this.removeStreamingHostFromSpaceProps(spaceId);
        StreamingDistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (existingDist == null) {
            throw new RuntimeException("No streaming distribution exists for space " + spaceId);
        }
        this.s3Client.deleteBucketPolicy(bucketName);
        taskResult.setResult("Disable Streaming Task completed successfully");
        String toReturn = taskResult.serialize();
        this.log.info("Result of disable-streaming task: " + toReturn);
        return toReturn;
    }
}

