/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3storage;

import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storage.StringDataStore;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;

public class StringDataStoreFactory {
    private StorageAccountManager storageAccountManager;

    public StringDataStoreFactory(StorageAccountManager storageAccountManager) {
        this.storageAccountManager = storageAccountManager;
    }

    public StringDataStore create(String hiddenSpaceName) {
        return new StringDataStore(hiddenSpaceName, this.getS3StorageProvider());
    }

    private S3StorageProvider getS3StorageProvider() {
        if (!this.storageAccountManager.isInitialized()) {
            throw new DuraCloudRuntimeException("storageAccountManager is not initialized!!!");
        }
        StorageAccount account = this.storageAccountManager.getPrimaryStorageAccount();
        return new S3StorageProvider(account.getUsername(), account.getPassword(), (Map<String, String>)account.getOptions());
    }
}

