/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaminghls;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.Distribution;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetDistributionRequest;
import com.amazonaws.services.s3.AmazonS3;
import java.util.List;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.DeleteStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.DeleteStreamingTaskResult;
import org.duracloud.s3task.streaminghls.BaseHlsTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHlsTaskRunner
extends BaseHlsTaskRunner {
    private final Logger log = LoggerFactory.getLogger(DeleteHlsTaskRunner.class);
    private static final String TASK_NAME = "delete-hls";
    private static final String DEPLOYED = "Deployed";

    public DeleteHlsTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3 s3Client, AmazonCloudFrontClient cfClient) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfClient = cfClient;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        DeleteStreamingTaskParameters taskParams = DeleteStreamingTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        this.log.info("Performing delete-hls task on space " + spaceId);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        DeleteStreamingTaskResult taskResult = new DeleteStreamingTaskResult();
        this.removeHlsStreamingHostFromSpaceProps(spaceId);
        this.s3Client.deleteBucketPolicy(bucketName);
        this.s3Client.deleteBucketCrossOriginConfiguration(bucketName);
        List<DistributionSummary> existingDists = this.getAllExistingWebDistributions(bucketName);
        if (existingDists != null && existingDists.size() > 0) {
            for (DistributionSummary existingDist : existingDists) {
                String distId = existingDist.getId();
                if (existingDist.isEnabled().booleanValue()) {
                    this.setDistributionState(distId, false);
                }
                Runnable deleteWorker = () -> this.waitAndDelete(distId);
                new Thread(deleteWorker).start();
            }
        } else {
            throw new RuntimeException("No streaming distribution exists for space " + spaceId);
        }
        taskResult.setResult("delete-hls task completed successfully");
        String toReturn = taskResult.serialize();
        this.log.info("Result of delete-hls task: " + toReturn);
        return toReturn;
    }

    private void waitAndDelete(String distId) {
        this.waitForDisabled(distId);
        GetDistributionConfigResult result = this.cfClient.getDistributionConfig(new GetDistributionConfigRequest(distId));
        this.cfClient.deleteDistribution(new DeleteDistributionRequest().withId(distId).withIfMatch(result.getETag()));
    }

    private void waitForDisabled(String distId) {
        long maxTime = 1800000L;
        long start = System.currentTimeMillis();
        boolean deployed = this.isDeployed(distId);
        while (!deployed) {
            if (System.currentTimeMillis() < start + maxTime) {
                this.sleep(10000L);
                deployed = this.isDeployed(distId);
                continue;
            }
            String error = "Timeout Reached waiting for distribution to be disabled. Please wait a few minutes and try again.";
            throw new RuntimeException(error);
        }
    }

    private boolean isDeployed(String distId) {
        Distribution dist = this.cfClient.getDistribution(new GetDistributionRequest(distId)).getDistribution();
        return DEPLOYED.equals(dist.getStatus());
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            this.log.warn("sleep interrupted");
        }
    }
}

