/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaminghls;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.DistributionList;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.s3.AmazonS3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHlsTaskRunner
implements TaskRunner {
    private final Logger log = LoggerFactory.getLogger(BaseHlsTaskRunner.class);
    public static final String HLS_STREAMING_HOST_PROP = "hls-streaming-host";
    public static final String HLS_STREAMING_TYPE_PROP = "hls-streaming-type";
    public static final String S3_ORIGIN_SUFFIX = ".s3.amazonaws.com";
    public static final String S3_ORIGIN_OAI_PREFIX = "origin-access-identity/cloudfront/";
    protected static final int maxRetries = 8;
    protected StorageProvider s3Provider;
    protected S3StorageProvider unwrappedS3Provider;
    protected AmazonS3 s3Client;
    protected AmazonCloudFrontClient cfClient;
    protected String cfAccountId;
    protected String cfKeyId;
    protected String cfKeyPath;
    protected String dcHost;

    public abstract String getName();

    public abstract String performTask(String var1);

    protected DistributionSummary getExistingDistribution(String bucketName) {
        List<DistributionSummary> dists = this.getAllExistingWebDistributions(bucketName);
        if (dists.isEmpty()) {
            return null;
        }
        return dists.get(0);
    }

    private boolean isDistFromBucket(String bucketName, DistributionSummary distSummary) {
        String bucketOrigin = bucketName + S3_ORIGIN_SUFFIX;
        for (Origin distOrigin : distSummary.getOrigins().getItems()) {
            if (!bucketOrigin.equals(distOrigin.getDomainName())) continue;
            return true;
        }
        return false;
    }

    protected List<DistributionSummary> getAllExistingWebDistributions(String bucketName) {
        ArrayList<DistributionSummary> distListForBucket = new ArrayList<DistributionSummary>();
        DistributionList distList = this.cfClient.listDistributions(new ListDistributionsRequest()).getDistributionList();
        List webDistList = distList.getItems();
        while (distList.isTruncated().booleanValue()) {
            distList = this.cfClient.listDistributions(new ListDistributionsRequest().withMarker(distList.getNextMarker())).getDistributionList();
            webDistList.addAll(distList.getItems());
        }
        for (DistributionSummary distSummary : webDistList) {
            if (!this.isDistFromBucket(bucketName, distSummary)) continue;
            distListForBucket.add(distSummary);
        }
        return distListForBucket;
    }

    protected void setDistributionState(String distId, boolean enabled) {
        GetDistributionConfigResult result = this.cfClient.getDistributionConfig(new GetDistributionConfigRequest(distId));
        DistributionConfig distConfig = result.getDistributionConfig();
        distConfig.setEnabled(Boolean.valueOf(enabled));
        this.cfClient.updateDistribution(new UpdateDistributionRequest().withDistributionConfig(distConfig).withIfMatch(result.getETag()).withId(distId));
    }

    protected Iterator<String> getSpaceContents(String spaceId) {
        for (int i = 0; i < 8; ++i) {
            try {
                return this.s3Provider.getSpaceContents(spaceId, null);
            }
            catch (Exception e) {
                this.log.warn("Exception encountered attempting to get contents for space: " + spaceId + ", error message: " + e.getMessage());
                this.wait(i);
                continue;
            }
        }
        throw new DuraCloudRuntimeException("Exceeded retries attempting to get space contents for " + spaceId);
    }

    protected void removeHlsStreamingHostFromSpaceProps(String spaceId) {
        Map spaceProps = this.s3Provider.getSpaceProperties(spaceId);
        if (spaceProps.containsKey(HLS_STREAMING_HOST_PROP) || spaceProps.containsKey(HLS_STREAMING_TYPE_PROP)) {
            spaceProps.remove(HLS_STREAMING_HOST_PROP);
            spaceProps.remove(HLS_STREAMING_TYPE_PROP);
            this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
        }
    }

    protected void wait(int index) {
        try {
            Thread.sleep(1000 * index);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void checkThatStreamingServiceIsEnabled(String spaceId, String taskName) {
        Map spaceProperties = this.s3Provider.getSpaceProperties(spaceId);
        if (!spaceProperties.containsKey(HLS_STREAMING_HOST_PROP)) {
            throw new UnsupportedTaskException(taskName, "The " + taskName + " task can only be used after a space has been configured to enable HLS streaming. Use enable-hls to enable HLS streaming on this space.");
        }
    }

    public static enum STREAMING_TYPE {
        OPEN,
        SECURE;

    }
}

