/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaminghls;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.CloudFrontCookieSigner;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.spec.InvalidKeySpecException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.common.util.IOUtil;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storage.StringDataStore;
import org.duracloud.s3storage.StringDataStoreFactory;
import org.duracloud.s3storageprovider.dto.GetSignedCookiesUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedCookiesUrlTaskResult;
import org.duracloud.s3storageprovider.dto.SignedCookieData;
import org.duracloud.s3task.streaminghls.BaseHlsTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GetHlsSignedCookiesUrlTaskRunner
extends BaseHlsTaskRunner {
    public static final int DEFAULT_MINUTES_TO_EXPIRE = 480;
    private final Logger log = LoggerFactory.getLogger(GetHlsSignedCookiesUrlTaskRunner.class);
    private static final String TASK_NAME = "get-signed-cookies-url";
    private StringDataStoreFactory dataStoreFactory;

    public GetHlsSignedCookiesUrlTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonCloudFrontClient cfClient, StringDataStoreFactory dataStoreFactory, String cfKeyId, String cfKeyPath) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.cfClient = cfClient;
        this.dataStoreFactory = dataStoreFactory;
        this.cfKeyId = cfKeyId;
        this.cfKeyPath = cfKeyPath.trim();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        GetSignedCookiesUrlTaskParameters taskParams = GetSignedCookiesUrlTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        String ipAddress = taskParams.getIpAddress();
        int minutesToExpire = taskParams.getMinutesToExpire();
        if (minutesToExpire <= 0) {
            minutesToExpire = 480;
        }
        String redirectUrl = taskParams.getRedirectUrl();
        this.log.info("Performing get-signed-cookies-url task with parameters: spaceId=" + spaceId + ", minutesToExpire=" + minutesToExpire + ", ipAddress=" + ipAddress + ", redirectUrl=" + redirectUrl);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        this.checkThatStreamingServiceIsEnabled(spaceId, TASK_NAME);
        DistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (null == existingDist) {
            throw new UnsupportedTaskException(TASK_NAME, "The get-signed-cookies-url task can only be used after a space has been configured to enable secure streaming. Use enable-hls to enable secure streaming on this space.");
        }
        String domainName = existingDist.getDomainName();
        Calendar expireCalendar = Calendar.getInstance();
        expireCalendar.add(12, minutesToExpire);
        HashMap<String, String> signedCookies = new HashMap<String, String>();
        try {
            File cfKeyPathFile = this.getCfKeyPathFile(this.cfKeyPath);
            CloudFrontCookieSigner.CookiesForCustomPolicy cookies = CloudFrontCookieSigner.getCookiesForCustomPolicy((SignerUtils.Protocol)SignerUtils.Protocol.https, (String)domainName, (File)cfKeyPathFile, (String)"*", (String)this.cfKeyId, (Date)expireCalendar.getTime(), null, (String)ipAddress);
            signedCookies.put((String)cookies.getPolicy().getKey(), (String)cookies.getPolicy().getValue());
            signedCookies.put((String)cookies.getSignature().getKey(), (String)cookies.getSignature().getValue());
            signedCookies.put((String)cookies.getKeyPairId().getKey(), (String)cookies.getKeyPairId().getValue());
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new RuntimeException("Error encountered attempting to create signed cookies in task get-signed-cookies-url: " + e.getMessage(), e);
        }
        String token = this.storeCookies(signedCookies, domainName, redirectUrl);
        GetSignedCookiesUrlTaskResult taskResult = new GetSignedCookiesUrlTaskResult();
        taskResult.setSignedCookiesUrl("https://" + domainName + "/cookies?token=" + token);
        String toReturn = taskResult.serialize();
        this.log.info("Result of get-signed-cookies-url task: " + toReturn);
        return toReturn;
    }

    private File getCfKeyPathFile(String cfKeyPath) throws IOException {
        if (cfKeyPath.startsWith("s3://")) {
            File keyFile = new File(System.getProperty("java.io.tmpdir"), "cloudfront-key.der");
            if (!keyFile.exists()) {
                Resource resource = S3ProviderUtil.getS3ObjectByUrl(cfKeyPath);
                File tmpFile = IOUtil.writeStreamToFile((InputStream)resource.getInputStream());
                tmpFile.renameTo(keyFile);
                keyFile.deleteOnExit();
            }
            return keyFile;
        }
        return new File(cfKeyPath);
    }

    private String storeCookies(Map<String, String> signedCookies, String streamingHost, String redirectUrl) {
        SignedCookieData signedCookieData = new SignedCookieData();
        signedCookieData.setSignedCookies(signedCookies);
        signedCookieData.setStreamingHost(streamingHost);
        signedCookieData.setRedirectUrl(redirectUrl);
        String cookiesData = signedCookieData.serialize();
        StringDataStore signedCookieStore = this.dataStoreFactory.create("signedcookies");
        return signedCookieStore.storeData(cookiesData);
    }
}

