/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.context;

import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.UserUtil;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextUtil
implements UserUtil {
    private final Logger log = LoggerFactory.getLogger(SecurityContextUtil.class);

    public String getCurrentUsername() throws NoUserLoggedInException {
        DuracloudUserDetails userDetails = this.getCurrentUserDetails();
        return userDetails.getUsername();
    }

    public Credential getCurrentUser() throws NoUserLoggedInException {
        DuracloudUserDetails userDetails = this.getCurrentUserDetails();
        Credential credential = new Credential(userDetails.getUsername(), userDetails.getPassword());
        this.log.debug("user in context: " + credential.toString());
        return credential;
    }

    public DuracloudUserDetails getCurrentUserDetails() throws NoUserLoggedInException {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication auth = context.getAuthentication();
        if (null == auth) {
            this.log.debug("no user-auth found.");
            throw new NoUserLoggedInException();
        }
        Object obj = auth.getPrincipal();
        if (obj instanceof DuracloudUserDetails) {
            return (DuracloudUserDetails)((Object)obj);
        }
        this.log.debug("no user logged in: {}", (Object)obj.getClass().getName());
        throw new NoUserLoggedInException();
    }
}

