/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.common.model.AclType;
import org.duracloud.security.domain.HttpVerb;
import org.duracloud.security.vote.SpaceAccessVoter;
import org.duracloud.security.vote.VoterUtil;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.CollectionUtils;

public class SpaceReadAccessVoter
extends SpaceAccessVoter {
    private final Logger log = LoggerFactory.getLogger(SpaceReadAccessVoter.class);
    private List<String> pathExemptions = null;

    public SpaceReadAccessVoter(StorageProviderFactory storageProviderFactory, UserDetailsService userDetailsService) {
        this(storageProviderFactory, userDetailsService, new LinkedList<String>());
    }

    public SpaceReadAccessVoter(StorageProviderFactory storageProviderFactory, UserDetailsService userDetailsService, List<String> pathExemptions) {
        super(storageProviderFactory, userDetailsService);
        this.pathExemptions = pathExemptions;
    }

    public int vote(Authentication auth, Object resource, Collection config) {
        String label = "SpaceReadAccessVoterImpl";
        if (resource != null && !this.supports(resource.getClass())) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
            return 0;
        }
        HttpServletRequest httpRequest = this.getHttpServletRequest(resource);
        if (null == httpRequest) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        HttpVerb verb = this.getHttpVerb(httpRequest);
        if (null == verb) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (!verb.isRead()) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
            return 0;
        }
        if (this.isAdmin(auth.getName())) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (this.isOpenResource(httpRequest)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        Map<String, AclType> acls = this.getSpaceACLs(httpRequest);
        if (acls.containsKey("acl-group-public")) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (auth instanceof AnonymousAuthenticationToken) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        if (this.hasReadAccess(auth.getName(), acls)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        List<String> userGroups = this.getUserGroups(auth);
        if (this.groupsHaveReadAccess(userGroups, acls)) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
            return 1;
        }
        if (this.matchesPathExemptions(httpRequest)) {
            return 1;
        }
        int grant = -1;
        this.log.debug(VoterUtil.debugText(label, auth, config, resource, grant));
        return grant;
    }

    private boolean matchesPathExemptions(HttpServletRequest httpRequest) {
        String path = httpRequest.getPathInfo();
        if (!CollectionUtils.isEmpty(this.pathExemptions)) {
            for (String pattern : this.pathExemptions) {
                if (!path.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }
}

