/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.duracloud.SecurityUsersDocument;
import org.duracloud.SecurityUsersType;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.xml.SecurityUserElementReader;
import org.duracloud.security.xml.SecurityUserElementWriter;

public class SecurityUsersDocumentBinding {
    public static List<SecurityUserBean> createSecurityUsersFrom(InputStream xml) {
        try {
            SecurityUsersDocument doc = SecurityUsersDocument.Factory.parse(xml);
            return SecurityUserElementReader.createSecurityUsersFrom(doc);
        }
        catch (XmlException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }

    public static String createDocumentFrom(Collection<SecurityUserBean> users) {
        SecurityUsersDocument doc = SecurityUsersDocument.Factory.newInstance();
        if (null != users) {
            SecurityUsersType usersType = SecurityUserElementWriter.createSecurityUsersElementFrom(users);
            doc.setSecurityUsers(usersType);
        }
        return SecurityUsersDocumentBinding.docToString(doc);
    }

    private static String docToString(XmlObject doc) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            doc.save((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException((Throwable)e);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                throw new DuraCloudRuntimeException((Throwable)e);
            }
        }
        return outputStream.toString();
    }
}

