/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.common.error.InvalidUsernameException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.model.RootUserCredential;
import org.duracloud.common.model.SystemUserCredential;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements DuracloudUserDetailsService {
    private final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    private Map<String, DuracloudUserDetails> usersTable = new HashMap<String, DuracloudUserDetails>();
    private static final Credential systemUser = new SystemUserCredential();
    private static final RootUserCredential rootUser = new RootUserCredential();

    public UserDetailsServiceImpl() {
        this.initializeUsers();
    }

    private void initializeUsers() {
        this.usersTable.clear();
        ArrayList<String> grants = new ArrayList<String>();
        grants.add("ROLE_ADMIN");
        grants.add("ROLE_USER");
        SecurityUserBean system = new SecurityUserBean(systemUser.getUsername(), systemUser.getPassword(), grants);
        grants = new ArrayList();
        grants.add("ROLE_ROOT");
        grants.add("ROLE_ADMIN");
        grants.add("ROLE_USER");
        SecurityUserBean root = new SecurityUserBean(rootUser.getUsername(), rootUser.getRootEncodedPassword(), grants);
        this.addUser(system);
        this.addUser(root);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails userDetails = this.usersTable.get(username);
        if (null == userDetails) {
            throw new UsernameNotFoundException(username);
        }
        return userDetails;
    }

    @Override
    public void setUsers(List<SecurityUserBean> users) {
        this.initializeUsers();
        for (SecurityUserBean u : users) {
            if (!this.isCustomUser(u)) {
                throw new InvalidUsernameException(u.getUsername());
            }
            this.addUser(u);
        }
    }

    private void addUser(SecurityUserBean u) {
        List<String> grantBeans = u.getGrantedAuthorities();
        GrantedAuthority[] grants = new GrantedAuthority[grantBeans.size()];
        for (int i = 0; i < grantBeans.size(); ++i) {
            grants[i] = new GrantedAuthorityImpl(grantBeans.get(i));
        }
        DuracloudUserDetails user = new DuracloudUserDetails(u.getUsername(), u.getPassword(), u.getEmail(), u.getIpLimits(), u.isEnabled(), u.isAccountNonExpired(), u.isCredentialsNonExpired(), u.isAccountNonLocked(), Arrays.asList(grants), u.getGroups());
        this.usersTable.put(u.getUsername(), user);
    }

    @Override
    public List<SecurityUserBean> getUsers() {
        ArrayList<SecurityUserBean> users = new ArrayList<SecurityUserBean>();
        for (DuracloudUserDetails user : this.usersTable.values()) {
            SecurityUserBean bean = this.createUserBean(user);
            if (!this.isCustomUser(bean)) continue;
            users.add(bean);
        }
        return users;
    }

    @Override
    public SecurityUserBean getUserByUsername(String username) {
        for (DuracloudUserDetails user : this.usersTable.values()) {
            SecurityUserBean bean = this.createUserBean(user);
            if (!this.isCustomUser(bean) || !bean.getUsername().equals(username)) continue;
            return bean;
        }
        return null;
    }

    private SecurityUserBean createUserBean(DuracloudUserDetails user) {
        List<String> grants = this.getGrants(user.getAuthorities().toArray(new GrantedAuthority[0]));
        return new SecurityUserBean(user.getUsername(), user.getPassword(), user.getEmail(), user.getIpLimits(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), grants, user.getGroups());
    }

    private boolean isCustomUser(SecurityUserBean user) {
        String username = user.getUsername();
        String rootname = rootUser.getUsername();
        String sysname = systemUser.getUsername();
        return !username.equals(rootname) && !username.equals(sysname);
    }

    private List<String> getGrants(GrantedAuthority[] gAuths) {
        ArrayList<String> grants = new ArrayList<String>();
        if (gAuths != null && gAuths.length > 0) {
            for (GrantedAuthority gAuth : gAuths) {
                grants.add(gAuth.getAuthority());
            }
        }
        return grants;
    }
}

