/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.domain.SecurityUserBean;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements DuracloudUserDetailsService {
    private final Logger log = LoggerFactory.getLogger(UserDetailsServiceImpl.class);
    private Map<String, DuracloudUserDetails> usersTable = new HashMap<String, DuracloudUserDetails>();

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails userDetails = this.usersTable.get(username);
        if (null == userDetails) {
            throw new UsernameNotFoundException(username);
        }
        return userDetails;
    }

    @Override
    public void setUsers(List<SecurityUserBean> users) {
        for (SecurityUserBean u : users) {
            this.addUser(u);
        }
    }

    private void addUser(SecurityUserBean u) {
        List grantBeans = u.getGrantedAuthorities();
        GrantedAuthority[] grants = new GrantedAuthority[grantBeans.size()];
        for (int i = 0; i < grantBeans.size(); ++i) {
            grants[i] = new SimpleGrantedAuthority((String)grantBeans.get(i));
        }
        DuracloudUserDetails user = new DuracloudUserDetails(u.getUsername(), u.getPassword(), u.getEmail(), u.getIpLimits(), u.isEnabled(), u.isAccountNonExpired(), u.isCredentialsNonExpired(), u.isAccountNonLocked(), Arrays.asList(grants), u.getGroups());
        this.usersTable.put(u.getUsername(), user);
    }

    @Override
    public List<SecurityUserBean> getUsers() {
        ArrayList<SecurityUserBean> users = new ArrayList<SecurityUserBean>();
        for (DuracloudUserDetails user : this.usersTable.values()) {
            SecurityUserBean bean = this.createUserBean(user);
            users.add(bean);
        }
        return users;
    }

    @Override
    public SecurityUserBean getUserByUsername(String username) {
        for (DuracloudUserDetails user : this.usersTable.values()) {
            SecurityUserBean bean = this.createUserBean(user);
            if (!bean.getUsername().equals(username)) continue;
            return bean;
        }
        return null;
    }

    private SecurityUserBean createUserBean(DuracloudUserDetails user) {
        List<String> grants = this.getGrants(user.getAuthorities().toArray(new GrantedAuthority[0]));
        return new SecurityUserBean(user.getUsername(), user.getPassword(), user.getEmail(), user.getIpLimits(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), grants, user.getGroups());
    }

    private List<String> getGrants(GrantedAuthority[] gAuths) {
        ArrayList<String> grants = new ArrayList<String>();
        if (gAuths != null && gAuths.length > 0) {
            for (GrantedAuthority gAuth : gAuths) {
                grants.add(gAuth.getAuthority());
            }
        }
        return grants;
    }
}

