/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.security.vote.VoterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class UserIpLimitsAccessVoter
implements AccessDecisionVoter {
    private final Logger log = LoggerFactory.getLogger(UserIpLimitsAccessVoter.class);

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class aClass) {
        return FilterInvocation.class.isAssignableFrom(aClass);
    }

    public int vote(Authentication auth, Object resource, Collection config) {
        String label = "UserIpLimitsAccessVoter";
        if (resource != null && !this.supports(resource.getClass())) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
            return 0;
        }
        FilterInvocation invocation = (FilterInvocation)resource;
        HttpServletRequest httpRequest = invocation.getHttpRequest();
        if (null == httpRequest) {
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        String userIpLimits = this.getUserIpLimits(auth);
        if (null != userIpLimits && !userIpLimits.equals("")) {
            String[] ipLimits;
            String requestIp = httpRequest.getRemoteAddr();
            for (String ipLimit : ipLimits = userIpLimits.split(";")) {
                if (!this.ipInRange(requestIp, ipLimit)) continue;
                this.log.debug(VoterUtil.debugText(label, auth, config, resource, 1));
                return 1;
            }
            this.log.debug(VoterUtil.debugText(label, auth, config, resource, -1));
            return -1;
        }
        this.log.debug(VoterUtil.debugText(label, auth, config, resource, 0));
        return 0;
    }

    protected String getUserIpLimits(Authentication auth) {
        Object principal = auth.getPrincipal();
        if (principal instanceof DuracloudUserDetails) {
            DuracloudUserDetails userDetails = (DuracloudUserDetails)((Object)principal);
            return userDetails.getIpLimits();
        }
        return null;
    }

    protected boolean ipInRange(String ipAddress, String range) {
        IpAddressMatcher addressMatcher = new IpAddressMatcher(range);
        return addressMatcher.matches(ipAddress);
    }
}

