/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.vote;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.common.model.AclType;
import org.duracloud.security.domain.HttpVerb;
import org.duracloud.security.impl.DuracloudUserDetails;
import org.duracloud.security.util.AuthorizationHelper;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.FilterInvocation;

public abstract class SpaceAccessVoter
implements AccessDecisionVoter {
    private final Logger log = LoggerFactory.getLogger(SpaceAccessVoter.class);
    private UserDetailsService userDetailsService;
    private AuthorizationHelper authHelper;
    private StorageProviderFactory storageProviderFactory;
    private static String[] EXCEPTIONAL_PATH_PREFIXES = new String[]{"/manifest/", "/bit-integrity/", "/report/space/"};

    public SpaceAccessVoter(StorageProviderFactory storageProviderFactory, UserDetailsService userDetailsService) {
        this.storageProviderFactory = storageProviderFactory;
        this.userDetailsService = userDetailsService;
        this.authHelper = new AuthorizationHelper(storageProviderFactory);
    }

    protected boolean isOpenResource(HttpServletRequest httpRequest) {
        String spaceId = this.getSpaceId(httpRequest);
        if (null == spaceId) {
            return false;
        }
        return spaceId.equals("spaces") || spaceId.equals("stores") || spaceId.equals("acl") || spaceId.equals("aux") || spaceId.equals("task");
    }

    protected String getStoreId(HttpServletRequest httpRequest) {
        int idIndex;
        String name;
        String storeId = null;
        String query = httpRequest.getQueryString();
        if (null == query) {
            return null;
        }
        int storeIdIndex = (query = query.toLowerCase()).indexOf(name = "storeid");
        if (storeIdIndex > -1 && (idIndex = query.indexOf("=", storeIdIndex) + 1) == storeIdIndex + name.length() + 1) {
            int nextParamIndex = query.indexOf("&", idIndex);
            int end = nextParamIndex > -1 ? nextParamIndex : query.length();
            storeId = query.substring(idIndex, end);
        }
        return storeId;
    }

    protected String getSpaceId(HttpServletRequest httpRequest) {
        String spaceId = httpRequest.getPathInfo();
        if (null == spaceId) {
            return null;
        }
        return this.extractSpaceId(spaceId);
    }

    protected String extractSpaceId(String pathInfo) {
        int slashIndex;
        for (String prefix : EXCEPTIONAL_PATH_PREFIXES) {
            if (!pathInfo.startsWith(prefix)) continue;
            return pathInfo.substring(prefix.length());
        }
        String spaceId = pathInfo;
        if (spaceId.startsWith("/")) {
            spaceId = pathInfo.substring(1);
        }
        if ((slashIndex = spaceId.indexOf("/")) > 0) {
            spaceId = spaceId.substring(0, slashIndex);
        }
        return spaceId;
    }

    protected boolean hasContentId(HttpServletRequest httpRequest) {
        return this.getContentId(httpRequest) != null;
    }

    protected String getContentId(HttpServletRequest httpRequest) {
        String path;
        String spaceId = this.getSpaceId(httpRequest);
        if (null != spaceId && !(path = httpRequest.getPathInfo()).endsWith(spaceId)) {
            return path.substring(path.indexOf(spaceId) + spaceId.length() + 1);
        }
        return null;
    }

    protected Map<String, AclType> getSpaceACLs(HttpServletRequest request) {
        String storeId = this.getStoreId(request);
        String spaceId = this.getSpaceId(request);
        return this.getSpaceACLs(storeId, spaceId);
    }

    protected Map<String, AclType> getSpaceACLs(String storeId, String spaceId) {
        return this.authHelper.getSpaceACLs(storeId, spaceId);
    }

    protected HttpVerb getHttpVerb(HttpServletRequest httpRequest) {
        String method = httpRequest.getMethod();
        try {
            return HttpVerb.valueOf(method);
        }
        catch (RuntimeException e) {
            this.log.error("Error determining verb: {}, exception: {}", (Object)method, (Object)e);
            return null;
        }
    }

    protected List<String> getUserGroups(Authentication auth) {
        DuracloudUserDetails userDetails = (DuracloudUserDetails)((Object)auth.getPrincipal());
        return userDetails.getGroups();
    }

    protected boolean groupsHaveReadAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.authHelper.groupsHaveReadAccess(userGroups, acls);
    }

    protected boolean groupsHaveWriteAccess(List<String> userGroups, Map<String, AclType> acls) {
        return this.authHelper.groupsHaveAccess(userGroups, acls, false);
    }

    protected boolean hasReadAccess(String name, Map<String, AclType> acls) {
        return this.authHelper.hasReadAccess(name, acls);
    }

    protected boolean hasWriteAccess(String name, Map<String, AclType> acls) {
        return this.authHelper.hasWriteAccess(name, acls);
    }

    protected boolean isAdmin(String name) {
        UserDetails userDetails;
        try {
            userDetails = this.userDetailsService.loadUserByUsername(name);
        }
        catch (UsernameNotFoundException e) {
            this.log.debug("Not admin: {}, error: {}", (Object)name, (Object)e);
            return false;
        }
        for (GrantedAuthority authority : userDetails.getAuthorities()) {
            if (!"ROLE_ADMIN".equals(authority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public StorageProviderFactory getStorageProviderFactory() {
        return this.storageProviderFactory;
    }

    protected HttpServletRequest getHttpServletRequest(Object resource) {
        FilterInvocation invocation = (FilterInvocation)resource;
        HttpServletRequest request = invocation.getHttpRequest();
        if (null == request) {
            String msg = "null request: '" + resource + "'";
            this.log.warn("HttpServletRequest was null!  " + msg);
        }
        return request;
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class aClass) {
        return FilterInvocation.class.isAssignableFrom(aClass);
    }

    protected boolean isSnapshotMetadataSpace(HttpServletRequest httpRequest) {
        String spaceId = this.getSpaceId(httpRequest);
        return "x-snapshot-metadata".equals(spaceId);
    }
}

