/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.duracloud.appconfig.domain.NotificationConfig;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.snapshot.bridge.rest.InitParams;
import org.duracloud.snapshot.bridge.rest.ResponseDetails;
import org.duracloud.snapshot.db.DatabaseConfig;
import org.duracloud.snapshot.db.DatabaseInitializer;
import org.duracloud.snapshot.service.BridgeConfiguration;
import org.duracloud.snapshot.service.Finalizer;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.RestoreManagerConfig;
import org.duracloud.snapshot.service.SnapshotJobManager;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.impl.ExecutionListenerConfig;
import org.duracloud.snapshot.service.impl.RestoreJobExecutionListener;
import org.duracloud.snapshot.service.impl.SnapshotJobExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
public class GeneralResource {
    private static Logger log = LoggerFactory.getLogger(GeneralResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private SnapshotJobManager jobManager;
    private DatabaseInitializer databaseInitializer;
    private SnapshotJobExecutionListener snapshotJobListener;
    private RestoreJobExecutionListener restoreJobListener;
    private RestoreManager restorationManager;
    private NotificationManager notificationManager;
    private BridgeConfiguration bridgeConfiguration;
    private Finalizer finalizer;

    @Autowired
    public GeneralResource(SnapshotJobManager jobManager, RestoreManager restorationManager, DatabaseInitializer databaseInitializer, SnapshotJobExecutionListener snapshotJobListener, RestoreJobExecutionListener restoreListener, NotificationManager notificationManager, Finalizer finalizer, BridgeConfiguration bridgeConfiguration) {
        this.jobManager = jobManager;
        this.restorationManager = restorationManager;
        this.databaseInitializer = databaseInitializer;
        this.snapshotJobListener = snapshotJobListener;
        this.restoreJobListener = restoreListener;
        this.notificationManager = notificationManager;
        this.finalizer = finalizer;
        this.bridgeConfiguration = bridgeConfiguration;
    }

    @Path(value="init")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response init(InitParams initParams) {
        try {
            this.initBridgeConfiguration(initParams);
            this.initializeLocalDirectories(initParams);
            this.initDatabase(initParams);
            this.initExecutionListener(initParams);
            this.initJobManager(initParams);
            this.initRestorationResource(initParams);
            this.initNotificationManager(initParams);
            this.finalizer.initialize(initParams.getFinalizerPeriodMs());
            log.info("successfully initialized bridge application.");
            return Response.accepted().entity((Object)new ResponseDetails("success!")).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)new ResponseDetails("failure!" + e.getMessage())).build();
        }
    }

    private void initBridgeConfiguration(InitParams initParams) {
        this.bridgeConfiguration.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        this.bridgeConfiguration.setDuracloudUsername(initParams.getDuracloudUsername());
        this.bridgeConfiguration.setDuracloudPassword(initParams.getDuracloudPassword());
        this.bridgeConfiguration.setContentRootDir(new File(initParams.getContentDirRoot()));
    }

    private void initNotificationManager(InitParams initParams) {
        NotificationConfig notifyConfig = new NotificationConfig();
        notifyConfig.setType(NotificationType.EMAIL.name());
        notifyConfig.setUsername(initParams.getAwsAccessKey());
        notifyConfig.setPassword(initParams.getAwsSecretKey());
        notifyConfig.setOriginator(initParams.getOriginatorEmailAddress());
        ArrayList<NotificationConfig> notifyConfigs = new ArrayList<NotificationConfig>();
        notifyConfigs.add(notifyConfig);
        this.notificationManager.initializeNotifiers(notifyConfigs);
    }

    private void initRestorationResource(InitParams initParams) {
        RestoreManagerConfig config = new RestoreManagerConfig();
        config.setRestorationRootDir(initParams.getContentDirRoot());
        config.setDpnEmailAddresses(initParams.getDpnEmailAddresses());
        config.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        config.setDuracloudUsername(initParams.getDuracloudUsername());
        config.setDuracloudPassword(initParams.getDuracloudPassword());
        this.restorationManager.init(config, this.jobManager);
    }

    private void initDatabase(InitParams initParams) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setUrl(initParams.getDatabaseURL());
        dbConfig.setUsername(initParams.getDatabaseUser());
        dbConfig.setPassword(initParams.getDatabasePassword());
        dbConfig.setClean(initParams.isClean());
        this.databaseInitializer.init(dbConfig);
    }

    private void initExecutionListener(InitParams initParams) {
        ExecutionListenerConfig notifyConfig = new ExecutionListenerConfig();
        notifyConfig.setSesUsername(initParams.getAwsAccessKey());
        notifyConfig.setSesPassword(initParams.getAwsSecretKey());
        notifyConfig.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        notifyConfig.setDpnEmailAddresses(initParams.getDpnEmailAddresses());
        notifyConfig.setOriginatorEmailAddress(initParams.getOriginatorEmailAddress());
        notifyConfig.setContentRoot(new File(initParams.getContentDirRoot()));
        this.snapshotJobListener.init(notifyConfig);
        this.restoreJobListener.init(notifyConfig, initParams.getDaysToExpireRestore().intValue());
    }

    private void initJobManager(InitParams initParams) {
        if (StringUtils.isBlank((String)initParams.getWorkDir())) {
            throw new IllegalArgumentException("workDir must not be blank.");
        }
        if (StringUtils.isBlank((String)initParams.getContentDirRoot())) {
            throw new IllegalArgumentException("contentDirRoot must not be blank.");
        }
        File workDir = this.createDirectoryIfNotExists(initParams.getWorkDir());
        File contentDirRoot = this.createDirectoryIfNotExists(initParams.getContentDirRoot());
        SnapshotJobManagerConfig jobManagerConfig = new SnapshotJobManagerConfig();
        jobManagerConfig.setDuracloudUsername(initParams.getDuracloudUsername());
        jobManagerConfig.setDuracloudPassword(initParams.getDuracloudPassword());
        jobManagerConfig.setContentRootDir(contentDirRoot);
        jobManagerConfig.setWorkDir(workDir);
        this.jobManager.init(jobManagerConfig);
    }

    private void initializeLocalDirectories(InitParams initParams) {
    }

    private File createDirectoryIfNotExists(String path) {
        File wdir = new File(path);
        if (!wdir.exists() && !wdir.mkdirs()) {
            throw new RuntimeException("failed to initialize " + path + ": directory could not be created.");
        }
        if (!wdir.canWrite()) {
            throw new RuntimeException(wdir.getAbsolutePath() + " must be writable.");
        }
        return wdir;
    }

    @Path(value="version")
    @GET
    @Produces(value={"application/json"})
    public Response version() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/application.properties");
            Properties props = new Properties();
            props.load(is);
            String version = props.get("version").toString();
            String buildNumber = props.get("buildNumber").toString();
            return Response.ok().entity((Object)("{\"version\":\"" + version + "\",\"build\":\"" + buildNumber + "\"}")).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

