/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.duracloud.snapshot.bridge.rest.ResponseDetails;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.dto.bridge.CompleteRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetRestoreBridgeResult;
import org.duracloud.snapshot.service.RestorationNotFoundException;
import org.duracloud.snapshot.service.RestoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/restore")
public class RestoreResource {
    private static Logger log = LoggerFactory.getLogger(RestoreResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private RestoreManager restorationManager;

    @Autowired
    public RestoreResource(RestoreManager restorationManager) {
        this.restorationManager = restorationManager;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response restoreSnapshot(CreateRestoreBridgeParameters params) {
        try {
            DuracloudEndPointConfig destination = new DuracloudEndPointConfig();
            destination.setHost(params.getHost());
            destination.setPort(Integer.valueOf(params.getPort()).intValue());
            destination.setStoreId(params.getStoreId());
            destination.setSpaceId(params.getSpaceId());
            Restoration result = this.restorationManager.restoreSnapshot(params.getSnapshotId(), destination, params.getUserEmail());
            log.info("executed restore snapshot:  params=" + params + ", result = " + result);
            return Response.created(null).entity((Object)new CreateRestoreBridgeResult(result.getRestorationId(), result.getStatus())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{restorationId}")
    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="restorationId") String restorationId) {
        try {
            Restoration restoration = this.restorationManager.get(restorationId);
            return Response.ok().entity((Object)this.toGetRestoreBridgeResult(restoration)).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="by-snapshot/{snapshotId}")
    @GET
    @Produces(value={"application/json"})
    public Response getBySnapshot(@PathParam(value="snapshotId") String snapshotId) {
        try {
            Restoration restoration = this.restorationManager.getBySnapshotId(snapshotId);
            return Response.ok().entity((Object)this.toGetRestoreBridgeResult(restoration)).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    private GetRestoreBridgeResult toGetRestoreBridgeResult(Restoration restoration) {
        DuracloudEndPointConfig destination = restoration.getDestination();
        GetRestoreBridgeResult result = new GetRestoreBridgeResult();
        result.setRestoreId(restoration.getRestorationId());
        result.setSnapshotId(restoration.getSnapshot().getName());
        result.setStartDate(restoration.getStartDate());
        result.setEndDate(restoration.getEndDate());
        result.setExpirationDate(restoration.getExpirationDate());
        result.setStatus(restoration.getStatus());
        result.setStatusText(restoration.getStatusText());
        result.setDestinationStoreId(destination.getStoreId());
        result.setDestinationHost(destination.getHost());
        result.setDestinationPort(destination.getPort());
        result.setDestinationSpaceId(destination.getSpaceId());
        return result;
    }

    @Path(value="{restorationId}/complete")
    @POST
    @Produces(value={"application/json"})
    public Response restoreComplete(@PathParam(value="restorationId") String restorationId) {
        try {
            Restoration restoration = this.restorationManager.restoreCompleted(restorationId);
            log.info("executed restoreComplete for {}", (Object)restoration);
            return Response.ok().entity((Object)new CompleteRestoreBridgeResult(restoration.getStatus(), restoration.getStatusText())).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }
}

