/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest.config;

import org.aopalliance.aop.Advice;
import org.duracloud.client.util.StoreClientUtil;
import org.duracloud.common.aop.RetryAdvice;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.snapshot.bridge.rest.config.ApplicationConfig;
import org.duracloud.snapshot.bridge.rest.config.BridgeRetryAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplicationConfig {
    static Logger log = LoggerFactory.getLogger(ApplicationConfig.class);

    public ApplicationConfig() {
        log.info("creating ApplicationConfig instance...");
    }

    @Bean
    public StoreClientUtil storeClientUtil(RetryAdvice advice) {
        ProxiedStoreClientUtil storeClientUtil = new ProxiedStoreClientUtil(this, advice);
        ProxyFactoryBean proxyFactoryBean = new ProxyFactoryBean();
        proxyFactoryBean.addAdvice((Advice)advice);
        proxyFactoryBean.setTarget((Object)storeClientUtil);
        return (StoreClientUtil)proxyFactoryBean.getObject();
    }

    @Bean
    public RetryAdvice retryAdvice(NotificationManager notificationManager) {
        return new BridgeRetryAdvice(notificationManager);
    }
}

