/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest.config;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.duracloud.common.aop.RetryAdvice;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.snapshot.bridge.rest.config.ApplicationConfig;

@Aspect
class BridgeRetryAdvice
extends RetryAdvice {
    private NotificationManager notificationManager;
    private Map<Object, Date> lastNotificationSentMap = new HashMap();
    private long minWaitBetweenNotificationsInSeconds = 3600L;

    public BridgeRetryAdvice(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
        this.setMaxRetries(3);
        this.setWaitTime(3000);
    }

    @Pointcut(value="execution(public * org.duracloud.storeclient.ContentStore.*(..)) || execution(public * org.duracloud.client.util.StoreClientUtil.*(..))")
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return super.invoke(invocation);
        }
        catch (Throwable t) {
            try {
                Date lastNotifcationSent = (Date)this.lastNotificationSentMap.get(invocation.getThis());
                Date nextNotification = new Date();
                if (lastNotifcationSent != null) {
                    nextNotification = new Date(lastNotifcationSent.getTime() + this.minWaitBetweenNotificationsInSeconds * 1000L);
                }
                if (nextNotification.getTime() <= System.currentTimeMillis()) {
                    InetAddress lh = InetAddress.getLocalHost();
                    this.notificationManager.sendAdminNotification(NotificationType.EMAIL, "The bridge (" + lh.getHostName() + "/" + lh.getHostAddress() + ") " + "failed to access duracloud instance with store client: ", t.getMessage() + "-->" + invocation.getThis());
                    this.lastNotificationSentMap.put(invocation.getThis(), new Date());
                }
            }
            catch (Exception ex) {
                ApplicationConfig.log.error("failed to send notification: " + ex.getMessage() + "->" + t.getMessage(), (Throwable)ex);
            }
            throw t;
        }
    }
}

