/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.SnapshotNotFoundException;
import org.duracloud.snapshot.bridge.rest.ResponseDetails;
import org.duracloud.snapshot.bridge.rest.SnapshotAlreadyExistsException;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.model.SnapshotContentItem;
import org.duracloud.snapshot.db.model.SnapshotHistory;
import org.duracloud.snapshot.db.repo.SnapshotContentItemRepo;
import org.duracloud.snapshot.db.repo.SnapshotRepo;
import org.duracloud.snapshot.dto.SnapshotHistoryItem;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.dto.SnapshotSummary;
import org.duracloud.snapshot.dto.bridge.CancelSnapshotBridgeResult;
import org.duracloud.snapshot.dto.bridge.CompleteSnapshotBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CompleteSnapshotBridgeResult;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetSnapshotBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetSnapshotContentBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetSnapshotHistoryBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetSnapshotListBridgeResult;
import org.duracloud.snapshot.dto.bridge.RestartSnapshotBridgeResult;
import org.duracloud.snapshot.dto.bridge.SnapshotErrorBridgeParameters;
import org.duracloud.snapshot.dto.bridge.SnapshotErrorBridgeResult;
import org.duracloud.snapshot.dto.bridge.UpdateSnapshotHistoryBridgeParameters;
import org.duracloud.snapshot.dto.bridge.UpdateSnapshotHistoryBridgeResult;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.duracloud.snapshot.service.AlternateIdAlreadyExistsException;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.SnapshotJobManager;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.PropertiesSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/snapshot")
public class SnapshotResource {
    private static Logger log = LoggerFactory.getLogger(SnapshotResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private SnapshotJobManager jobManager;
    private SnapshotManager snapshotManager;
    private SnapshotContentItemRepo snapshotContentItemRepo;
    private SnapshotRepo snapshotRepo;
    private EventLog eventLog;

    @Autowired
    public SnapshotResource(SnapshotJobManager jobManager, SnapshotManager snapshotManager, SnapshotRepo snapshotRepo, SnapshotContentItemRepo snapshotContentItemRepo, EventLog eventLog) {
        this.jobManager = jobManager;
        this.snapshotManager = snapshotManager;
        this.snapshotRepo = snapshotRepo;
        this.snapshotContentItemRepo = snapshotContentItemRepo;
        this.eventLog = eventLog;
    }

    @GET
    @Produces(value={"application/json"})
    public Response list(@QueryParam(value="host") String host, @QueryParam(value="storeId") String storeId, @QueryParam(value="status") SnapshotStatus status) {
        try {
            List snapshots = this.listSnapshots(host, storeId, status);
            ArrayList<SnapshotSummary> summaries = new ArrayList<SnapshotSummary>(snapshots.size());
            for (Snapshot snapshot : snapshots) {
                summaries.add(this.createSnapshotSummary(snapshot));
            }
            log.debug("returning {}", (Object)snapshots);
            return Response.ok().entity((Object)new GetSnapshotListBridgeResult(summaries)).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    private SnapshotSummary createSnapshotSummary(Snapshot snapshot) {
        DuracloudEndPointConfig source = snapshot.getSource();
        SnapshotSummary summary = new SnapshotSummary(snapshot.getName(), snapshot.getStatus(), snapshot.getDescription(), source.getStoreId(), source.getSpaceId());
        return summary;
    }

    protected List<Snapshot> listSnapshots(String host, String storeId, SnapshotStatus status) {
        if (null != host) {
            if (null != storeId) {
                if (null != status) {
                    return this.snapshotRepo.findBySourceHostAndSourceStoreIdAndStatus(host, storeId, status);
                }
                return this.snapshotRepo.findBySourceHostAndSourceStoreId(host, storeId);
            }
            if (null != status) {
                return this.snapshotRepo.findBySourceHostAndStatus(host, status);
            }
            return this.snapshotRepo.findBySourceHost(host);
        }
        if (null != storeId) {
            if (null != status) {
                return this.snapshotRepo.findBySourceStoreIdAndStatus(storeId, status);
            }
            return this.snapshotRepo.findBySourceStoreId(storeId);
        }
        if (null != status) {
            return this.snapshotRepo.findByStatusOrderBySnapshotDateAsc(status);
        }
        return this.snapshotRepo.findAll();
    }

    @Path(value="{snapshotId}")
    @GET
    @Produces(value={"application/json"})
    public Response getSnapshot(@PathParam(value="snapshotId") String snapshotId) {
        try {
            Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
            if (snapshot == null) {
                throw new SnapshotNotFoundException(snapshotId);
            }
            GetSnapshotBridgeResult result = new GetSnapshotBridgeResult();
            DuracloudEndPointConfig source = snapshot.getSource();
            result.setDescription(snapshot.getDescription());
            result.setSnapshotDate(snapshot.getSnapshotDate());
            result.setSnapshotId(snapshot.getName());
            result.setSourceHost(source.getHost());
            result.setSourceSpaceId(source.getSpaceId());
            result.setSourceStoreId(source.getStoreId());
            result.setStatus(snapshot.getStatus());
            result.setMemberId(snapshot.getMemberId());
            result.setTotalSizeInBytes(snapshot.getTotalSizeInBytes());
            result.setContentItemCount(Long.valueOf(this.snapshotContentItemRepo.countBySnapshotName(snapshotId)));
            result.setAlternateIds(snapshot.getSnapshotAlternateIds());
            log.debug("got snapshot:" + result);
            return Response.ok().entity((Object)result).build();
        }
        catch (SnapshotNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/restart")
    @POST
    @Produces(value={"application/json"})
    public Response restart(@PathParam(value="snapshotId") String snapshotId) {
        log.info("attempting restart of snapshot " + snapshotId);
        try {
            Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
            if (snapshot == null) {
                throw new SnapshotNotFoundException(snapshotId);
            }
            log.debug("snapshot {} found.", (Object)snapshot);
            SnapshotStatus status = snapshot.getStatus();
            if (!status.equals((Object)SnapshotStatus.FAILED_TO_TRANSFER_FROM_DURACLOUD)) {
                String message = "Snapshot can only be restarted when it has reached a failure state. ( snapshot=" + snapshot + ")";
                throw new SnapshotException(message, null);
            }
            snapshot.setEndDate(null);
            snapshot.setStatusText("restarting");
            snapshot.setStatus(SnapshotStatus.INITIALIZED);
            snapshot = (Snapshot)this.snapshotRepo.saveAndFlush((Object)snapshot);
            this.eventLog.logSnapshotUpdate(snapshot);
            SnapshotStatus snapshotStatus = snapshot.getStatus();
            this.jobManager.executeSnapshot(snapshotId);
            String message = MessageFormat.format("successfully restarted snapshot: {0}", snapshotStatus);
            log.info(message);
            RestartSnapshotBridgeResult result = new RestartSnapshotBridgeResult(message, snapshotStatus);
            return Response.accepted().entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/cancel")
    @POST
    @Produces(value={"application/json"})
    public Response cancel(@PathParam(value="snapshotId") String snapshotId) throws SnapshotException {
        log.debug("attempting cancellation of snapshot " + snapshotId);
        Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
        if (snapshot == null) {
            throw new SnapshotNotFoundException(snapshotId);
        }
        log.debug("snapshot {} found.", (Object)snapshot);
        SnapshotStatus status = snapshot.getStatus();
        if (status.equals((Object)SnapshotStatus.CLEANING_UP)) {
            String message = "Snapshot cannot be cancelled in the cleaning up phase ( snapshot=" + snapshot + ")";
            return Response.serverError().entity((Object)new ResponseDetails(message)).build();
        }
        this.jobManager.cancelSnapshot(snapshotId);
        this.snapshotManager.deleteSnapshot(snapshotId);
        CancelSnapshotBridgeResult result = new CancelSnapshotBridgeResult(SnapshotStatus.CANCELLED, "Cancellation succeeded.  Snapshot and all metadata has been deleted.");
        return Response.ok().entity((Object)result).build();
    }

    @Path(value="{snapshotId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@PathParam(value="snapshotId") String snapshotId, CreateSnapshotBridgeParameters params) {
        log.debug("creating snapshot " + snapshotId + "; params = " + params);
        Snapshot snapshot = null;
        try {
            if (this.snapshotRepo.findByName(snapshotId) != null) {
                throw new SnapshotAlreadyExistsException("A snapshot with id " + snapshotId + " already exists - please use a different name");
            }
            snapshot = new Snapshot();
            DuracloudEndPointConfig source = new DuracloudEndPointConfig();
            source.setHost(params.getHost());
            source.setPort(Integer.valueOf(params.getPort()).intValue());
            source.setSpaceId(params.getSpaceId());
            source.setStoreId(params.getStoreId());
            Date now = new Date();
            snapshot.setModified(now);
            snapshot.setStartDate(now);
            Date snapshotDate = new Date(SnapshotIdentifier.parseSnapshotId((String)snapshotId).getTimestamp());
            snapshot.setSnapshotDate(snapshotDate);
            snapshot.setName(snapshotId);
            snapshot.setSource(source);
            snapshot.setDescription(params.getDescription());
            snapshot.setStatus(SnapshotStatus.INITIALIZED);
            String userEmail = params.getUserEmail();
            snapshot.setUserEmail(userEmail);
            snapshot.setMemberId(params.getMemberId());
            snapshot = (Snapshot)this.snapshotRepo.saveAndFlush((Object)snapshot);
            this.eventLog.logSnapshotUpdate(snapshot);
            this.jobManager.executeSnapshot(snapshotId);
            CreateSnapshotBridgeResult result = new CreateSnapshotBridgeResult(snapshotId, snapshot.getStatus());
            String history = "[{'snapshot-action':'SNAPSHOT_INITIATED'},{'initiating-user':'" + userEmail + "'},{'" + "snapshot-id" + "':'" + snapshotId + "'}]";
            this.snapshotManager.updateHistory(snapshot, history);
            log.info("successfully created snapshot: {}", (Object)result);
            return Response.created(null).entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            if (snapshot != null && snapshot.getId() != null) {
                log.info("cleaning up post exception...");
                try {
                    log.debug("deleting newly created snapshot...");
                    this.snapshotRepo.delete((Serializable)snapshot.getId());
                }
                catch (Exception e) {
                    log.error("failed to cleanup snapshot " + snapshotId + ": " + e.getMessage(), (Throwable)e);
                }
                log.info("cleaning up complete");
            }
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/complete")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response complete(@PathParam(value="snapshotId") String snapshotId, CompleteSnapshotBridgeParameters params) {
        try {
            CharSequence history;
            Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
            List alternateIds = params.getAlternateIds();
            String altIds = "[]";
            if (alternateIds != null && !alternateIds.isEmpty()) {
                snapshot = this.snapshotManager.addAlternateSnapshotIds(snapshot, alternateIds);
                history = new StringBuilder();
                ((StringBuilder)history).append("[");
                boolean first = true;
                for (String id : alternateIds) {
                    if (!first) {
                        ((StringBuilder)history).append(",");
                    }
                    ((StringBuilder)history).append("'" + id + "'");
                    first = false;
                }
                ((StringBuilder)history).append("]");
                altIds = ((StringBuilder)history).toString();
            }
            history = "[{'snapshot-action':'SNAPSHOT_COMPLETED'},{'snapshot-id':'" + snapshotId + "'},{'" + "alternate-ids" + "':" + altIds + "}]";
            this.snapshotManager.updateHistory(snapshot, (String)history);
            snapshot = this.snapshotManager.transferToDpnNodeComplete(snapshotId);
            log.info("successfully processed snapshot complete notification from DPN: {}", (Object)snapshot);
            return Response.ok(null).entity((Object)new CompleteSnapshotBridgeResult(snapshot.getStatus(), snapshot.getStatusText())).build();
        }
        catch (AlternateIdAlreadyExistsException ex) {
            log.warn(ex.getMessage());
            return Response.status((int)400).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/error")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response error(@PathParam(value="snapshotId") String snapshotId, SnapshotErrorBridgeParameters params) {
        try {
            Snapshot snapshot = this.snapshotManager.transferError(snapshotId, params.getError());
            log.info("Processed snapshot error notification from DPN: {}", (Object)snapshot);
            return Response.ok((Object)new SnapshotErrorBridgeResult(snapshot.getStatus(), snapshot.getStatusText())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/content")
    @GET
    @Produces(value={"application/json"})
    public Response getContent(@PathParam(value="snapshotId") String snapshotId, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="prefix") String prefix) {
        try {
            if (page == null) {
                page = 0;
            }
            if (pageSize == null || pageSize < 1 || pageSize > 1000) {
                pageSize = 1000;
            }
            PageRequest pageable = new PageRequest(page.intValue(), pageSize.intValue());
            List items = this.snapshotContentItemRepo.findBySnapshotNameAndContentIdStartingWithOrderByContentIdAsc(snapshotId, prefix, (Pageable)pageable);
            ArrayList<org.duracloud.snapshot.dto.SnapshotContentItem> snapshotItems = new ArrayList<org.duracloud.snapshot.dto.SnapshotContentItem>();
            for (SnapshotContentItem item : items) {
                org.duracloud.snapshot.dto.SnapshotContentItem snapshotItem = new org.duracloud.snapshot.dto.SnapshotContentItem();
                snapshotItem.setContentId(item.getContentId());
                String metadata = item.getMetadata();
                if (null != metadata) {
                    snapshotItem.setContentProperties(PropertiesSerializer.deserialize((String)metadata));
                }
                snapshotItems.add(snapshotItem);
            }
            GetSnapshotContentBridgeResult result = new GetSnapshotContentBridgeResult();
            result.setContentItems(snapshotItems);
            result.setTotalCount(Long.valueOf(this.snapshotContentItemRepo.countBySnapshotName(snapshotId)));
            log.debug("returning results: {}", (Object)result);
            return Response.ok(null).entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/history")
    @GET
    @Produces(value={"application/json"})
    public Response getHistory(@PathParam(value="snapshotId") String snapshotId, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize) {
        try {
            if (page == null) {
                page = 0;
            }
            if (pageSize == null || pageSize < 1 || pageSize > 1000) {
                pageSize = 1000;
            }
            Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
            List allItems = snapshot.getSnapshotHistory();
            int fromIndex = page * pageSize;
            int toIndex = page * pageSize + pageSize;
            int n = toIndex = toIndex > allItems.size() ? allItems.size() : toIndex;
            fromIndex = fromIndex < 0 ? 0 : (fromIndex > toIndex ? (toIndex - pageSize > 0 ? toIndex - pageSize : 0) : fromIndex);
            List items = allItems.subList(fromIndex, toIndex);
            ArrayList<SnapshotHistoryItem> historyItems = new ArrayList<SnapshotHistoryItem>();
            for (SnapshotHistory item : items) {
                SnapshotHistoryItem historyItem = new SnapshotHistoryItem();
                historyItem.setHistory(item.getHistory());
                historyItem.setHistoryDate(item.getHistoryDate());
                historyItems.add(historyItem);
            }
            GetSnapshotHistoryBridgeResult result = new GetSnapshotHistoryBridgeResult();
            result.setHistoryItems(historyItems);
            result.setTotalCount(Long.valueOf(historyItems.size()));
            log.debug("returning results: {}", (Object)result);
            return Response.ok(null).entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{snapshotId}/history")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateHistory(@PathParam(value="snapshotId") String snapshotId, UpdateSnapshotHistoryBridgeParameters params) {
        try {
            Snapshot snapshot;
            if (params.getAlternate() == null) {
                return Response.serverError().entity((Object)new ResponseDetails("Incorrect parameters submitted!")).build();
            }
            Snapshot snapshot2 = snapshot = params.getAlternate() != false ? this.snapshotRepo.findBySnapshotAlternateIds(snapshotId) : this.snapshotRepo.findByName(snapshotId);
            if (snapshot != null) {
                if (params.getHistory() != null && params.getHistory().length() > 0) {
                    snapshot = this.snapshotManager.updateHistory(snapshot, params.getHistory());
                    log.info("successfully processed snapshot history update from DPN: {}", (Object)snapshot);
                } else {
                    log.info("did not process empty or null snapshot history update from DPN: {}", (Object)snapshot);
                }
                SnapshotSummary snapSummary = this.createSnapshotSummary(snapshot);
                List snapMeta = snapshot.getSnapshotHistory();
                String history = snapMeta != null && snapMeta.size() > 0 ? ((SnapshotHistory)snapMeta.get(snapMeta.size() - 1)).getHistory() : "";
                UpdateSnapshotHistoryBridgeResult result = new UpdateSnapshotHistoryBridgeResult(snapSummary, history);
                log.debug("Returning results of update snapshot history: {}", (Object)result);
                return Response.ok(null).entity((Object)result).build();
            }
            String error = "Snapshot with " + (params.getAlternate() != false ? "alternate " : "") + "id [" + snapshotId + "] not found!";
            return Response.serverError().entity((Object)new ResponseDetails(error)).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }
}

