/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest;

import java.text.MessageFormat;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.bridge.rest.ResponseDetails;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.dto.bridge.CancelRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.CompleteRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.GetRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.RequestRestoreBridgeParameters;
import org.duracloud.snapshot.dto.bridge.RequestRestoreBridgeResult;
import org.duracloud.snapshot.dto.bridge.RestartRestoreBridgeResult;
import org.duracloud.snapshot.service.RestorationNotFoundException;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/restore")
public class RestoreResource {
    private static Logger log = LoggerFactory.getLogger(RestoreResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private RestoreManager restorationManager;
    private SnapshotManager snapshotManager;

    @Autowired
    public RestoreResource(RestoreManager restorationManager, SnapshotManager snapshotManager) {
        this.restorationManager = restorationManager;
        this.snapshotManager = snapshotManager;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response restoreSnapshot(CreateRestoreBridgeParameters params) {
        try {
            DuracloudEndPointConfig destination = new DuracloudEndPointConfig();
            destination.setHost(params.getHost());
            destination.setPort(Integer.valueOf(params.getPort()).intValue());
            destination.setStoreId(params.getStoreId());
            destination.setSpaceId(params.getSpaceId());
            Restoration result = this.restorationManager.restoreSnapshot(params.getSnapshotId(), destination, params.getUserEmail());
            log.info("executed restore snapshot:  params=" + params + ", result = " + result);
            String history = "[{'restore-action':'RESTORE_INITIATED'},{'restore-id':'" + result.getRestorationId() + "'},{'" + "initiating-user" + "':'" + params.getUserEmail() + "'}]";
            this.snapshotManager.updateHistory(result.getSnapshot(), history);
            return Response.created(null).entity((Object)new CreateRestoreBridgeResult(result.getRestorationId(), result.getStatus())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{restoreId}/restart")
    @POST
    @Produces(value={"application/json"})
    public Response restart(@PathParam(value="restoreId") String restoreId) {
        log.info("attempting restart of restore " + restoreId);
        try {
            Restoration restore = this.restorationManager.get(restoreId);
            log.debug("restore {} found.", (Object)restore);
            RestoreStatus status = restore.getStatus();
            if (!status.equals((Object)RestoreStatus.ERROR)) {
                String message = "Restore can only be restarted when it has reached a failure state. ( restore=" + restore + ")";
                throw new SnapshotException(message, null);
            }
            restore = this.restorationManager.restartRestore(restore.getRestorationId());
            RestoreStatus restoreStatus = restore.getStatus();
            String message = MessageFormat.format("successfully restarted restore: {0}", restoreStatus);
            log.info(message);
            RestartRestoreBridgeResult result = new RestartRestoreBridgeResult(message, restoreStatus);
            return Response.accepted().entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{restoreId}/cancel")
    @POST
    @Produces(value={"application/json"})
    public Response cancel(@PathParam(value="restoreId") String restoreId) throws SnapshotException {
        log.debug("attempting cancellation of resotre " + restoreId);
        try {
            Restoration restore = this.restorationManager.get(restoreId);
            log.debug("restore {} found.", (Object)restore);
            RestoreStatus status = restore.getStatus();
            if (Arrays.asList(RestoreStatus.CLEANING_UP, RestoreStatus.RESTORATION_COMPLETE).contains(status)) {
                String message = "Restore cannot be cancelled in the cleaning up phase ( restoreId=" + restoreId + ")";
                throw new RuntimeException(message);
            }
            this.restorationManager.cancelRestore(restoreId);
            CancelRestoreBridgeResult result = new CancelRestoreBridgeResult("Cancellation succeeded.  The restore process has been stopped and all related metadata has been deleted.", RestoreStatus.CANCELLED);
            return Response.ok().entity((Object)result).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="/request")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response requestRestoreSnapshot(RequestRestoreBridgeParameters params) {
        try {
            DuracloudEndPointConfig destination = new DuracloudEndPointConfig();
            destination.setHost(params.getHost());
            destination.setPort(Integer.valueOf(params.getPort()).intValue());
            destination.setStoreId(params.getStoreId());
            Snapshot snapshot = this.restorationManager.requestRestoreSnapshot(params.getSnapshotId(), destination, params.getUserEmail());
            log.info("executed request restore snapshot:  params=" + params);
            String history = "[{'restore-action':'RESTORE_REQUESTED'},{'initiating-user':'" + params.getUserEmail() + "'}]";
            this.snapshotManager.updateHistory(snapshot, history);
            return Response.created(null).entity((Object)new RequestRestoreBridgeResult("Your request has been sent.")).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="{restorationId}")
    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="restorationId") String restorationId) {
        try {
            Restoration restoration = this.restorationManager.get(restorationId);
            return Response.ok().entity((Object)this.toGetRestoreBridgeResult(restoration)).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    @Path(value="by-snapshot/{snapshotId}")
    @GET
    @Produces(value={"application/json"})
    public Response getBySnapshot(@PathParam(value="snapshotId") String snapshotId) {
        try {
            Restoration restoration = this.restorationManager.getBySnapshotId(snapshotId);
            return Response.ok().entity((Object)this.toGetRestoreBridgeResult(restoration)).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }

    private GetRestoreBridgeResult toGetRestoreBridgeResult(Restoration restoration) {
        DuracloudEndPointConfig destination = restoration.getDestination();
        GetRestoreBridgeResult result = new GetRestoreBridgeResult();
        result.setRestoreId(restoration.getRestorationId());
        result.setSnapshotId(restoration.getSnapshot().getName());
        result.setStartDate(restoration.getStartDate());
        result.setEndDate(restoration.getEndDate());
        result.setExpirationDate(restoration.getExpirationDate());
        result.setStatus(restoration.getStatus());
        result.setStatusText(restoration.getStatusText());
        result.setDestinationStoreId(destination.getStoreId());
        result.setDestinationHost(destination.getHost());
        result.setDestinationPort(destination.getPort());
        result.setDestinationSpaceId(destination.getSpaceId());
        return result;
    }

    @Path(value="{restorationId}/complete")
    @POST
    @Produces(value={"application/json"})
    public Response restoreComplete(@PathParam(value="restorationId") String restorationId) {
        try {
            Restoration restoration = this.restorationManager.restoreCompleted(restorationId);
            log.info("executed restoreComplete for {}", (Object)restoration);
            return Response.ok().entity((Object)new CompleteRestoreBridgeResult(restoration.getStatus(), restoration.getStatusText())).build();
        }
        catch (RestorationNotFoundException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.status((int)404).entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Response.serverError().entity((Object)new ResponseDetails(ex.getMessage())).build();
        }
    }
}

