/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.bridge.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.notification.NotificationConfig;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.util.EncryptionUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.snapshot.bridge.rest.InitParams;
import org.duracloud.snapshot.bridge.rest.PurgeObsoleteDataTask;
import org.duracloud.snapshot.bridge.rest.ResponseDetails;
import org.duracloud.snapshot.bridge.rest.config.RootUserCredential;
import org.duracloud.snapshot.db.DatabaseConfig;
import org.duracloud.snapshot.db.DatabaseInitializer;
import org.duracloud.snapshot.service.AlreadyInitializedException;
import org.duracloud.snapshot.service.BridgeConfiguration;
import org.duracloud.snapshot.service.Finalizer;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.RestoreManagerConfig;
import org.duracloud.snapshot.service.SnapshotJobManager;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.impl.ExecutionListenerConfig;
import org.duracloud.snapshot.service.impl.RestoreJobExecutionListener;
import org.duracloud.snapshot.service.impl.SnapshotJobExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
@Lazy(value=false)
public class GeneralResource {
    private static Logger log = LoggerFactory.getLogger(GeneralResource.class);
    @Context
    HttpServletRequest request;
    @Context
    HttpHeaders headers;
    @Context
    UriInfo uriInfo;
    private static Timer Timer = new Timer();
    private SnapshotJobManager jobManager;
    private DatabaseInitializer databaseInitializer;
    private SnapshotJobExecutionListener snapshotJobListener;
    private RestoreJobExecutionListener restoreJobListener;
    private RestoreManager restorationManager;
    private NotificationManager notificationManager;
    private BridgeConfiguration bridgeConfiguration;
    private Finalizer finalizer;
    private PurgeObsoleteDataTask purgeObsoleteDataTask;

    @Autowired
    public GeneralResource(SnapshotJobManager jobManager, RestoreManager restorationManager, DatabaseInitializer databaseInitializer, SnapshotJobExecutionListener snapshotJobListener, RestoreJobExecutionListener restoreListener, NotificationManager notificationManager, Finalizer finalizer, BridgeConfiguration bridgeConfiguration, PurgeObsoleteDataTask purgeObsoleteDataTask) {
        this.jobManager = jobManager;
        this.restorationManager = restorationManager;
        this.databaseInitializer = databaseInitializer;
        this.snapshotJobListener = snapshotJobListener;
        this.restoreJobListener = restoreListener;
        this.notificationManager = notificationManager;
        this.finalizer = finalizer;
        this.bridgeConfiguration = bridgeConfiguration;
        this.purgeObsoleteDataTask = purgeObsoleteDataTask;
    }

    @PostConstruct
    public void init() {
        this.initFromStoreInitConfig();
    }

    @Path(value="init")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response init(InitParams initParams) {
        try {
            this.checkIfAlreadyInitialized();
            this.initBridgeConfiguration(initParams);
            this.initDatabase(initParams);
            this.initExecutionListener(initParams);
            this.initJobManager(initParams);
            this.initRestorationResource(initParams);
            this.initNotificationManager(initParams);
            this.finalizer.initialize(initParams.getFinalizerPeriodMs());
            initParams.setClean(false);
            this.writeInitConfigToDisk(initParams);
            log.info("successfully initialized bridge application.");
            return Response.accepted().entity((Object)new ResponseDetails("success!")).build();
        }
        catch (Exception e) {
            log.error("failed to initialize: " + e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)new ResponseDetails("failure!" + e.getMessage())).build();
        }
    }

    private void checkIfAlreadyInitialized() throws AlreadyInitializedException {
        if (this.jobManager.isInitialized()) {
            throw new AlreadyInitializedException("The bridge has already been initialized.");
        }
    }

    private void writeInitConfigToDisk(InitParams initParams) {
        EncryptionUtil encryptionUtil = this.getEncryptionUtil();
        try (FileWriter writer = new FileWriter(this.getStoreInitFile());){
            String serialized = this.getInitSerializer().serialize((Object)initParams);
            String encrypted = encryptionUtil.encrypt(serialized);
            writer.write(encrypted);
        }
        catch (IOException e) {
            log.error("failed to write init config: " + e.getMessage(), (Throwable)e);
        }
    }

    private void initFromStoreInitConfig() {
        File storedInitFile = this.getStoreInitFile();
        if (!storedInitFile.exists()) {
            log.info("The encrypted stored init file ({}) does not exist. Ignoring...", (Object)storedInitFile.getAbsolutePath());
            return;
        }
        try {
            log.info("Initializing from stored encrypted file ({})...", (Object)storedInitFile.getAbsolutePath());
            this.init(this.getStoredInitParams());
        }
        catch (IOException e) {
            log.error("failed to initialize from stored config: " + e.getMessage(), (Throwable)e);
        }
    }

    protected InitParams getStoredInitParams() throws IOException {
        File storedInitFile = this.getStoreInitFile();
        try (FileInputStream is = new FileInputStream(storedInitFile);){
            String encryptedString = IOUtil.readStringFromStream((InputStream)is);
            String decryptedString = this.getEncryptionUtil().decrypt(encryptedString);
            InitParams initParams = (InitParams)this.getInitSerializer().deserialize(decryptedString);
            return initParams;
        }
    }

    private EncryptionUtil getEncryptionUtil() {
        RootUserCredential rootCredential = new RootUserCredential();
        return new EncryptionUtil(rootCredential.getPassword());
    }

    protected File getStoreInitFile() {
        return new File(BridgeConfiguration.getBridgeRootDir(), "duracloud-bridge-init.dat");
    }

    private JaxbJsonSerializer<InitParams> getInitSerializer() {
        JaxbJsonSerializer serializer = new JaxbJsonSerializer(InitParams.class);
        return serializer;
    }

    private void initBridgeConfiguration(InitParams initParams) {
        this.bridgeConfiguration.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        this.bridgeConfiguration.setDuracloudUsername(initParams.getDuracloudUsername());
        this.bridgeConfiguration.setDuracloudPassword(initParams.getDuracloudPassword());
        assert (BridgeConfiguration.getBridgeRootDir().exists());
    }

    private void initNotificationManager(InitParams initParams) {
        NotificationConfig notifyConfig = new NotificationConfig();
        notifyConfig.setType(NotificationType.EMAIL.name());
        notifyConfig.setUsername(initParams.getAwsAccessKey());
        notifyConfig.setPassword(initParams.getAwsSecretKey());
        notifyConfig.setOriginator(initParams.getOriginatorEmailAddress());
        notifyConfig.setAdmins(Arrays.asList(initParams.getDuracloudEmailAddresses()));
        ArrayList<NotificationConfig> notifyConfigs = new ArrayList<NotificationConfig>();
        notifyConfigs.add(notifyConfig);
        this.notificationManager.initializeNotifiers(notifyConfigs);
    }

    private void initRestorationResource(InitParams initParams) {
        RestoreManagerConfig config = new RestoreManagerConfig();
        config.setRestorationRootDir(BridgeConfiguration.getContentRootDir().getAbsolutePath());
        config.setTargetStoreEmailAddresses(initParams.getTargetStoreEmailAddresses());
        config.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        config.setDuracloudUsername(initParams.getDuracloudUsername());
        config.setDuracloudPassword(initParams.getDuracloudPassword());
        this.restorationManager.init(config, this.jobManager);
    }

    private void initDatabase(InitParams initParams) {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setUrl(initParams.getDatabaseURL());
        dbConfig.setUsername(initParams.getDatabaseUser());
        dbConfig.setPassword(initParams.getDatabasePassword());
        dbConfig.setClean(initParams.isClean());
        this.databaseInitializer.init(dbConfig);
        Timer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 1000L, 86400000L);
    }

    private void initExecutionListener(InitParams initParams) {
        ExecutionListenerConfig notifyConfig = new ExecutionListenerConfig();
        notifyConfig.setSesUsername(initParams.getAwsAccessKey());
        notifyConfig.setSesPassword(initParams.getAwsSecretKey());
        notifyConfig.setDuracloudEmailAddresses(initParams.getDuracloudEmailAddresses());
        notifyConfig.setTargetStoreEmailAddresses(initParams.getTargetStoreEmailAddresses());
        notifyConfig.setOriginatorEmailAddress(initParams.getOriginatorEmailAddress());
        notifyConfig.setContentRoot(BridgeConfiguration.getContentRootDir());
        this.snapshotJobListener.init(notifyConfig);
        this.restoreJobListener.init(notifyConfig, initParams.getDaysToExpireRestore().intValue());
    }

    private void initJobManager(InitParams initParams) throws AlreadyInitializedException {
        SnapshotJobManagerConfig jobManagerConfig = new SnapshotJobManagerConfig();
        jobManagerConfig.setDuracloudUsername(initParams.getDuracloudUsername());
        jobManagerConfig.setDuracloudPassword(initParams.getDuracloudPassword());
        jobManagerConfig.setContentRootDir(BridgeConfiguration.getContentRootDir());
        jobManagerConfig.setWorkDir(BridgeConfiguration.getBridgeWorkDir());
        this.jobManager.init(jobManagerConfig);
    }

    @Path(value="version")
    @GET
    @Produces(value={"application/json"})
    public Response version() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/application.properties");
            Properties props = new Properties();
            props.load(is);
            String version = props.get("version").toString();
            String buildNumber = props.get("buildNumber").toString();
            return Response.ok().entity((Object)("{\"version\":\"" + version + "\",\"build\":\"" + buildNumber + "\"}")).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ PurgeObsoleteDataTask access$000(GeneralResource x0) {
        return x0.purgeObsoleteDataTask;
    }
}

