/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.db;

import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.snapshot.db.DatabaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class DatabaseInitializer
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseInitializer.class);
    private List<Resource> dropSchemas;
    private List<Resource> schemas;
    private BasicDataSource dataSource;
    private ApplicationContext context;

    public DatabaseInitializer(BasicDataSource dataSource, List<Resource> dropSchemas, List<Resource> schemas) {
        this.dataSource = dataSource;
        this.dropSchemas = dropSchemas;
        this.schemas = schemas;
    }

    public void init(DatabaseConfig databaseConfig) {
        DataSourceInitializer initializer = new DataSourceInitializer();
        this.dataSource.setUrl(databaseConfig.getUrl());
        this.dataSource.setUsername(databaseConfig.getUsername());
        this.dataSource.setPassword(databaseConfig.getPassword());
        this.dataSource.setInitialSize(5);
        this.dataSource.setMaxIdle(5);
        this.dataSource.setMaxTotal(50);
        this.dataSource.setMaxConnLifetimeMillis(14400L);
        this.dataSource.setTimeBetweenEvictionRunsMillis(900000L);
        initializer.setDataSource((DataSource)this.dataSource);
        initializer.setDatabasePopulator(this.databasePopulator(databaseConfig));
        try {
            initializer.afterPropertiesSet();
        }
        catch (Exception e) {
            Throwable rootCause = this.getRootCause(e);
            if (rootCause.getMessage().contains("already exists")) {
                LOGGER.info("Database initialization - tables already exist: {}", (Object)rootCause.getMessage());
            }
            throw e;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    private DatabasePopulator databasePopulator(DatabaseConfig databaseConfig) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        if (databaseConfig.isClean()) {
            for (Resource schema : this.dropSchemas) {
                populator.addScript(schema);
            }
        }
        for (Resource schema : this.schemas) {
            populator.addScript(schema);
        }
        return populator;
    }

    private Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return this.getRootCause(throwable.getCause());
        }
        return throwable;
    }
}

