/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.db.model;

import java.util.Comparator;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.duracloud.snapshot.db.model.BaseEntity;
import org.duracloud.snapshot.db.model.Snapshot;

@Entity
@Table(name="snapshot_content_item", uniqueConstraints={@UniqueConstraint(columnNames={"snapshot_id", "content_id_hash"})})
public class SnapshotContentItem
extends BaseEntity
implements Comparator<SnapshotContentItem> {
    @Column(name="content_id", nullable=false, length=1024)
    private String contentId;
    @Column(name="content_id_hash", nullable=false, length=50)
    private String contentIdHash;
    @ManyToOne(optional=false, targetEntity=Snapshot.class)
    @JoinColumn(name="snapshot_id", columnDefinition="bigint(20)", nullable=false)
    private Snapshot snapshot;
    @Column(length=1024)
    private String metadata;

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public int compare(SnapshotContentItem o1, SnapshotContentItem o2) {
        return o1.contentId.compareTo(o2.contentId);
    }

    public String getContentIdHash() {
        return this.contentIdHash;
    }

    public void setContentIdHash(String contentIdHash) {
        this.contentIdHash = contentIdHash;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

