/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.db.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.duracloud.snapshot.db.model.BaseEntity;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.SnapshotHistory;
import org.duracloud.snapshot.dto.SnapshotStatus;

@Entity
@Table(name="snapshot", uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class Snapshot
extends BaseEntity
implements Comparator<Snapshot> {
    @Column(name="name", nullable=false, length=256)
    private String name;
    @Column(name="description", nullable=true, length=512)
    private String description;
    private Date snapshotDate;
    @Embedded
    private DuracloudEndPointConfig source;
    private Date startDate;
    private Date endDate;
    @Enumerated(value=EnumType.STRING)
    private SnapshotStatus status;
    @Column(nullable=true, length=512)
    private String statusText;
    private String userEmail;
    private Long totalSizeInBytes = 0L;
    @Column(name="member_id", nullable=true, length=128)
    private String memberId = null;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="snapshot_alternate_ids", joinColumns={@JoinColumn(name="snapshot_id", columnDefinition="bigint(20)", nullable=false)})
    @Column(name="snapshot_alternate_id")
    private List<String> snapshotAlternateIds;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="snapshot")
    @OrderBy(value="historyDate DESC")
    private List<SnapshotHistory> snapshotHistory;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DuracloudEndPointConfig getSource() {
        return this.source;
    }

    public void setSource(DuracloudEndPointConfig source) {
        this.source = source;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public void setSnapshotDate(Date snapshotDate) {
        this.snapshotDate = snapshotDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public SnapshotStatus getStatus() {
        return this.status;
    }

    public void setStatus(SnapshotStatus status) {
        this.status = status;
    }

    public List<SnapshotHistory> getSnapshotHistory() {
        return this.snapshotHistory;
    }

    public void setSnapshotHistory(List<SnapshotHistory> snapshotHistory) {
        this.snapshotHistory = snapshotHistory;
    }

    public List<String> getSnapshotAlternateIds() {
        return this.snapshotAlternateIds;
    }

    public void addSnapshotAlternateIds(List<String> snapshotAlternateIds) {
        if (snapshotAlternateIds != null) {
            if (snapshotAlternateIds.size() > 0 && this.snapshotAlternateIds == null) {
                this.snapshotAlternateIds = new ArrayList<String>();
            }
            for (String snapshotAlternateId : snapshotAlternateIds) {
                if (this.snapshotAlternateIds.contains(snapshotAlternateId)) continue;
                this.snapshotAlternateIds.add(snapshotAlternateId);
            }
        }
    }

    @Override
    public int compare(Snapshot o1, Snapshot o2) {
        return o1.name.compareTo(o2.name);
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(Long totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

