/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.db.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.duracloud.snapshot.db.model.BaseEntity;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.dto.RestoreStatus;

@Entity
public class Restoration
extends BaseEntity {
    @ManyToOne(optional=true, targetEntity=Snapshot.class)
    @JoinColumn(name="snapshot_id", columnDefinition="bigint(20)")
    private Snapshot snapshot;
    @Embedded
    private DuracloudEndPointConfig destination;
    private Date startDate;
    private Date endDate;
    private Date expirationDate;
    @Enumerated(value=EnumType.STRING)
    private RestoreStatus status = RestoreStatus.INITIALIZED;
    @Column(length=512)
    private String statusText;
    private String userEmail;
    @Column(length=512, unique=true)
    private String restorationId;

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public DuracloudEndPointConfig getDestination() {
        return this.destination;
    }

    public void setDestination(DuracloudEndPointConfig destination) {
        this.destination = destination;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public RestoreStatus getStatus() {
        return this.status;
    }

    public void setStatus(RestoreStatus status) {
        this.status = status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getRestorationId() {
        return this.restorationId;
    }

    public void setRestorationId(String restorationId) {
        this.restorationId = restorationId;
    }
}

